/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.util.SchematicUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SchematicCreationGui
extends Screen {
    private TextFieldWidget nameField;
    private PlayerEntity player;
    private String[] buttonText = new String[]{"x--", "x++", "y--", "y++", "z--", "z++"};

    public SchematicCreationGui(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent("Test"));
        this.player = player;
    }

    public void init() {
        int i = this.width / 2;
        this.nameField = new TextFieldWidget(this.font, i - 70, 10, 140, 12, "TEST");
        this.nameField.func_146193_g(-1);
        this.nameField.func_146204_h(-1);
        this.nameField.func_146185_a(true);
        this.nameField.func_146203_f(100);
        this.nameField.func_146180_a("Schematic Name");
        this.children.add(this.nameField);
        this.addButton((Widget)new Button(i - 50, this.height - 70, 100, 20, "Back", button -> {
            RenderEvent.setCreatingSchematic(true);
            this.onClose();
        }));
        this.addButton((Widget)new Button(i - 50, this.height - 40, 100, 20, "Create", button -> {
            String fileName = this.nameField.func_146179_b();
            fileName = fileName.endsWith(".ccs") ? fileName : fileName + ".ccs";
            SchematicUtil.createCustomSchematic(this.player.field_70170_p, SchematicUtil.selectionPoints[0], SchematicUtil.selectionPoints[1], fileName);
            this.player.func_145747_a((ITextComponent)new StringTextComponent("Schematic file named " + fileName + " created!"));
            RenderEvent.setCreatingSchematic(false);
            SchematicUtil.selectionPoints[0] = null;
            SchematicUtil.selectionPoints[1] = null;
            this.onClose();
        }));
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 6; ++k) {
                int buttonID = j * 2 + k;
                this.addButton((Widget)new Button(i - 90 + k * 30, 50 * (j + 1), 25, 20, this.buttonText[k], button -> {
                    int idNormalized = buttonID % 6;
                    int point = buttonID / 6;
                    if (idNormalized == 0) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(-1, 0, 0);
                    } else if (idNormalized == 1) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(1, 0, 0);
                    } else if (idNormalized == 2) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(0, -1, 0);
                    } else if (idNormalized == 3) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(0, 1, 0);
                    } else if (idNormalized == 4) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(0, 0, -1);
                    } else if (idNormalized == 5) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].func_177982_a(0, 0, 1);
                    }
                }));
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.blit(0, 0, this.width, this.height, -1157627904, -1157627904);
        if (this.nameField != null) {
            this.nameField.render(mouseX, mouseY, partialTicks);
        }
        int i = this.width / 2;
        this.drawCenteredString(this.font, "Point 1 " + SchematicUtil.selectionPoints[0], i, 40, 0xFFFFFF);
        this.drawCenteredString(this.font, "Point 2 " + SchematicUtil.selectionPoints[1], i, 90, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }
}

