/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.items.CCubesItems;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.profiles.PlayerProfileManager;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.tileentities.TileChanceD20;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemChanceCube
extends BlockItem {
    public ItemChanceCube(BaseChanceBlock b) {
        super((Block)b, ItemChanceCube.getProps(b));
        this.setRegistryName(b.getRegistryName());
    }

    public static Item.Properties getProps(Block b) {
        Item.Properties props = new Item.Properties();
        if (!b.equals((Object)CCubesBlocks.GIANT_CUBE)) {
            props.func_200916_a(CCubesCore.modTab);
        }
        return props;
    }

    public void setChance(ItemStack stack, int chance) {
        CompoundNBT nbt;
        if (chance > 100 || chance < -101) {
            chance = -101;
        }
        if ((nbt = stack.func_77978_p()) == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("Chance", chance);
        stack.func_77982_d(nbt);
    }

    public int getChance(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return -101;
        }
        return stack.func_77978_p().func_74764_b("Chance") ? stack.func_77978_p().func_74762_e("Chance") : -101;
    }

    public String getChanceAsStringValue(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return "Random";
        }
        return stack.func_77978_p().func_74764_b("Chance") ? (stack.func_77978_p().func_74762_e("Chance") == -101 ? "Random" : "" + stack.func_77978_p().func_74762_e("Chance")) : "Random";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        Item item = stack.func_77973_b();
        if (!item.equals(Item.func_150898_a((Block)CCubesBlocks.CUBE_DISPENSER))) {
            String chance = this.getChanceAsStringValue(stack);
            list.add((ITextComponent)new StringTextComponent("Chance Value: " + chance));
        }
        if (item.equals((Object)CCubesItems.COMPACT_GIANT_CUBE)) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "WARNING: The Giant Chance Cube will probably cause lots damage and/or place a lot of blocks down... You've been warned."));
        } else if (item.equals((Object)CCubesItems.CHANCE_CUBE)) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Warning: It is recommended you don't open these in or next to your base."));
        } else if (item.equals((Object)CCubesItems.CHANCE_ICOSAHEDRON)) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "WORK IN PROGRESS!"));
        }
        if (item.equals((Object)CCubesItems.CHANCE_CUBE) || item.equals((Object)CCubesItems.CHANCE_ICOSAHEDRON)) {
            PlayerProfileManager ppm;
            list.add((ITextComponent)new StringTextComponent("==== Enabled Profiles ===="));
            if (Minecraft.func_71410_x().field_71439_g != null && (ppm = GlobalProfileManager.getPlayerProfileManager(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString())) != null) {
                for (String rewardName : ppm.getEnabledProfileNames()) {
                    list.add((ITextComponent)new StringTextComponent(rewardName));
                }
            }
        }
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        int chance;
        boolean placed = super.func_195941_b(context, state);
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te != null && (chance = this.getChance(context.func_195996_i())) != -101) {
            if (te instanceof TileChanceCube) {
                ((TileChanceCube)te).setChance(chance);
            } else if (te instanceof TileChanceD20) {
                ((TileChanceD20)te).setChance(chance);
            }
        }
        return placed;
    }
}

