/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.profiles;

import chanceCubes.CCubesCore;
import chanceCubes.profiles.BasicProfile;
import chanceCubes.profiles.IProfile;
import chanceCubes.profiles.PlayerProfileManager;
import chanceCubes.profiles.triggers.DifficultyTrigger;
import chanceCubes.profiles.triggers.DimensionChangeTrigger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Level;

public class GlobalProfileManager {
    private static final JsonParser PARSER = new JsonParser();
    private static final Gson GSON = new GsonBuilder().create();
    private static boolean worldProfilesLoaded = false;
    private static Map<IProfile, Boolean> profileDefaults = new HashMap<IProfile, Boolean>();
    private static Map<String, PlayerProfileManager> playerToProfiles = new HashMap<String, PlayerProfileManager>();
    private static File profileSaveFile = null;
    private static JsonObject profileSaveJson = new JsonObject();

    public static void registerProfile(IProfile profile) {
        GlobalProfileManager.registerProfile(profile, false);
    }

    public static void registerProfile(IProfile profile, boolean enabled) {
        if (profileDefaults.containsKey(profile)) {
            return;
        }
        profileDefaults.put(profile, enabled);
        if (profile instanceof BasicProfile) {
            for (IProfile subProfile : ((BasicProfile)profile).getSubProfiles()) {
                if (subProfile instanceof BasicProfile) {
                    GlobalProfileManager.registerProfile(subProfile, subProfile.getTriggers().size() == 0);
                    continue;
                }
                GlobalProfileManager.registerProfile(subProfile);
            }
        }
    }

    public static PlayerProfileManager getPlayerProfileManager(PlayerEntity player) {
        return GlobalProfileManager.getPlayerProfileManager(player.func_110124_au().toString());
    }

    public static PlayerProfileManager getPlayerProfileManager(String playerUUID) {
        if (!worldProfilesLoaded) {
            return null;
        }
        return playerToProfiles.computeIfAbsent(playerUUID, k -> {
            PlayerProfileManager playerProfileManager = new PlayerProfileManager(playerUUID);
            playerProfileManager.loadFromDefaults(profileDefaults);
            return playerProfileManager;
        });
    }

    public static void updateProfilesForWorld(ServerWorld world) {
        JsonObject playerProfiles;
        JsonObject profileJson;
        playerToProfiles.clear();
        profileSaveFile = new File(world.func_217485_w().func_75765_b(), "data/chancecubes.json");
        try {
            if (!profileSaveFile.exists()) {
                profileSaveFile.createNewFile();
                profileSaveJson = new JsonObject();
            } else {
                FileReader reader = new FileReader(profileSaveFile);
                JsonElement elem = PARSER.parse((Reader)reader);
                reader.close();
                profileSaveJson = elem.isJsonObject() ? elem.getAsJsonObject() : new JsonObject();
            }
        }
        catch (IOException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load the World specific profile data");
            e.printStackTrace();
            return;
        }
        if (profileSaveJson.has("profiles") && profileSaveJson.get("profiles").isJsonObject()) {
            profileJson = profileSaveJson.getAsJsonObject("profiles");
        } else {
            profileJson = new JsonObject();
            profileSaveJson.add("profiles", (JsonElement)profileJson);
        }
        for (Map.Entry playerProfilesElement : profileJson.entrySet()) {
            playerProfiles = ((JsonElement)playerProfilesElement.getValue()).getAsJsonObject();
            for (IProfile profile : profileDefaults.keySet()) {
                if (playerProfiles.has(profile.getID())) continue;
                playerProfiles.addProperty(profile.getID(), profileDefaults.get(profile));
            }
        }
        if (!GlobalProfileManager.saveWorldSaveFile()) {
            return;
        }
        for (Map.Entry playerProfilesElement : profileJson.entrySet()) {
            playerProfiles = ((JsonElement)playerProfilesElement.getValue()).getAsJsonObject();
            playerToProfiles.put((String)playerProfilesElement.getKey(), GlobalProfileManager.loadPlayerProfilesFromJson((String)playerProfilesElement.getKey(), playerProfiles));
        }
        worldProfilesLoaded = true;
    }

    public static void loadPlayerProfile(String playerUUID) {
        if (!worldProfilesLoaded || playerToProfiles.containsKey(playerUUID)) {
            return;
        }
        JsonObject profileJson = profileSaveJson.getAsJsonObject("profiles");
        for (Map.Entry playerProfilesElement : profileJson.entrySet()) {
            JsonObject playerProfiles = ((JsonElement)playerProfilesElement.getValue()).getAsJsonObject();
            if (!((String)playerProfilesElement.getKey()).equals(playerUUID)) continue;
            playerToProfiles.put(playerUUID, GlobalProfileManager.loadPlayerProfilesFromJson(playerUUID, playerProfiles));
            return;
        }
        JsonObject playerProfiles = new JsonObject();
        for (IProfile profile : profileDefaults.keySet()) {
            playerProfiles.addProperty(profile.getID(), profileDefaults.get(profile));
        }
        playerToProfiles.put(playerUUID, GlobalProfileManager.loadPlayerProfilesFromJson(playerUUID, playerProfiles));
        profileJson.add(playerUUID, (JsonElement)playerProfiles);
        GlobalProfileManager.saveWorldSaveFile();
    }

    private static PlayerProfileManager loadPlayerProfilesFromJson(String playerUUID, JsonObject playerProfilesJson) {
        PlayerProfileManager playerProfileManager = new PlayerProfileManager(playerUUID);
        playerProfileManager.loadFromJson(playerProfilesJson);
        return playerProfileManager;
    }

    public static void unloadProfilesForWorld() {
        worldProfilesLoaded = false;
        playerToProfiles.clear();
        profileSaveFile = null;
        profileSaveJson = new JsonObject();
    }

    public static void updateProfileSaveFile(String playerUUID, JsonObject json) {
        if (profileSaveFile != null && worldProfilesLoaded && profileSaveJson.has("profiles") && profileSaveJson.get("profiles").isJsonObject()) {
            profileSaveJson.getAsJsonObject("profiles").add(playerUUID, (JsonElement)json);
            GlobalProfileManager.saveWorldSaveFile();
        }
    }

    public static boolean saveWorldSaveFile() {
        try {
            FileWriter writer = new FileWriter(profileSaveFile);
            GSON.toJson((JsonElement)profileSaveJson, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to save the World specific profile data");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static List<String> getAllProfileNames(boolean sorted) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (IProfile prof : profileDefaults.keySet()) {
            toReturn.add(prof.getName());
        }
        if (sorted) {
            Collections.sort(toReturn);
        }
        return toReturn;
    }

    public static void clearProfiles() {
        profileDefaults.clear();
    }

    public static void removePlayerProfile(String uuid) {
        playerToProfiles.remove(uuid);
    }

    public static List<IProfile> getAllProfiles() {
        return new ArrayList<IProfile>(profileDefaults.keySet());
    }

    public static IProfile getProfileFromID(String id) {
        for (IProfile prof : GlobalProfileManager.getAllProfiles()) {
            if (!prof.getID().equals(id)) continue;
            return prof;
        }
        return null;
    }

    public static IProfile getProfilefromName(String name) {
        for (IProfile prof : profileDefaults.keySet()) {
            if (!prof.getName().equals(name)) continue;
            return prof;
        }
        return null;
    }

    public static boolean isWorldProfilesLoaded() {
        return worldProfilesLoaded;
    }

    public static void initProfiles() {
        BasicProfile profile = new BasicProfile("default", "Default", "Rewards that are disabled by default");
        profile.addDisabledRewards("chancecubes:clear_inventory");
        profile.addDisabledRewards("chancecubes:giant_chance_cube");
        GlobalProfileManager.registerProfile(profile, true);
        profile = new BasicProfile("no_explosions", "No Explosions", "Disable all rewards that use explode");
        profile.addDisabledRewards("chancecubes:tnt_structure", "chancecubes:explosion", "chancecubes:tnt_cat", "chancecubes:tnt_diamond", "chancecubes:tnt_bats", "chancecubes:coal_to_diamonds", "chancecubes:help_me", "chancecubes:nuke", "chancecubes:pssst", "chancecubes:surrounded_creeper", "chancecubes:troll_tnt", "chancecubes:ender_crystal_timer", "chancecubes:wait_for_it", "chancecubes:charged_creeper", "chancecubes:torches_to_creepers", "chancecubes:cake", "chancecubes:wolves_to_creepers", "chancecubes:monty_hall", "chancecubes:countdown", "chancecubes:heads_or_tails");
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("no_death_mg", "No Death Mini-games", "Disable all minigame rewards that kills the player if they lose");
        profile.addDisabledRewards("chancecubes:maze", "chancecubes:dig_build_reward", "chancecubes:matching", "chancecubes:math", "chancecubes:question");
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("no_status_effects", "No Potions/Effects", "Disable all rewards that throw a potion or give a status effect");
        profile.addDisabledRewards("chancecubes:poison", "chancecubes:wither_status_effect", "chancecubes:arrow_trap", "chancecubes:random_status_effect", "chancecubes:lingering_potions_ring", "chancecubes:surrounded_creeper", "chancecubes:mob_abilities_effects");
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("hardcore", "Hardcore", "For users who play on hardcore diffuculty");
        profile.addDisabledRewards("chancecubes:heads_or_tails", "chancecubes:monty_hall", "chancecubes:ender_crystal_timer", "chancecubes:wither");
        profile.addSubProfile(GlobalProfileManager.getProfileFromID("no_death_mg"));
        profile.addRewardChanceChange("chancecubes:half_heart", -100);
        profile.addRewardChanceChange("chancecubes:cave_spider_web", -90);
        profile.addRewardChanceChange("chancecubes:guardians", -85);
        profile.addTriggers(new DifficultyTrigger(profile, Difficulty.HARD));
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("nether", "Nether", "Updates the reward pool for when players are in the nether");
        profile.addDisabledRewards("chancecubes:rain", "chancecubes:sail_away", "chancecubes:squid_horde", "chancecubes:ice_cold", "chancecubes:hot_tub", "chancecubes:guardians", "chancecubes:nuke", "chancecubes:cats_and_dogs");
        profile.addTriggers(new DimensionChangeTrigger(profile, -1));
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("peaceful", "Peaceful", "For users who play on peaceful diffuculty. Removes rewards that have hostile Mobs (Doesn't remove TNT)");
        profile.addDisabledRewards("chancecubes:pssst", "chancecubes:horde", "chancecubes:silverfish_surround", "chancecubes:slime_man", "chancecubes:witch", "chancecubes:spawn_jerry", "chancecubes:spawn_glenn", "chancecubes:invisible_creeper", "chancecubes:knockback_zombie", "chancecubes:actual_invisible_ghast", "chancecubes:nether_jelly_fish", "chancecubes:quidditch", "chancecubes:one_man_army", "chancecubes:silvermite_stacks", "chancecubes:invizible_silverfish", "chancecubes:skeleton_bats", "chancecubes:cave_spider_web", "chancecubes:guardians", "chancecubes:cookie_monster", "chancecubes:charged_creeper", "chancecubes:torches_to_creepers", "chancecubes:herobrine", "chancecubes:surrounded", "chancecubes:surrounded_creeper", "chancecubes:wither", "chancecubes:wait_for_it", "chancecubes:cake", "chancecubes:wolves_to_creepers", "chancecubes:countdown", "chancecubes:mob_tower");
        profile.addTriggers(new DifficultyTrigger(profile, Difficulty.PEACEFUL));
        GlobalProfileManager.registerProfile(profile);
        profile = new BasicProfile("no_area_of_effects", "No Area of Effect Rewards", "Disables rewards that place blocks that have a 3x3x3 area of effect or greater (Does not include rewards that reset blocks to their original state after)");
        profile.addDisabledRewards("chancecubes:tnt_structure", "chancecubes:tnt_diamond", "chancecubes:string!", "chancecubes:carpet!", "chancecubes:squid_horde", "chancecubes:d-rude_sandstorm", "chancecubes:ice_cold", "chancecubes:watch_world_burn", "chancecubes:coal_to_diamonds", "chancecubes:hot_tub", "chancecubes:arrow_trap", "chancecubes:trampoline", "chancecubes:cave_spider_web", "chancecubes:guardians", "chancecubes:path_to_succeed", "chancecubes:help_me", "chancecubes:beacon_build", "chancecubes:disco", "chancecubes:5_prongs", "chancecubes:table_flip", "chancecubes:sky_block", "chancecubes:double_rainbow");
        GlobalProfileManager.registerProfile(profile);
    }
}

