/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.biodomeGen.BioDomeGen;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class BossBaseReward
extends BaseCustomReward {
    private String bossName;
    private List<Entity> trackedEntities = new ArrayList<Entity>();
    private List<Entity> trackedSubEntities = new ArrayList<Entity>();
    private List<PlayerEntity> trackedPlayers = new ArrayList<PlayerEntity>();
    private BioDomeGen domeGen;
    private BlockPos rewardCenterPos;

    public BossBaseReward(String bossName) {
        super("chancecubes:boss_" + bossName, -35);
        this.bossName = bossName.replace("_", " ");
    }

    @Override
    public void trigger(final World world, final BlockPos pos, final PlayerEntity player, final Map<String, Object> settings) {
        this.rewardCenterPos = pos;
        this.domeGen = new BioDomeGen(player);
        this.domeGen.genRandomDome(pos.func_177982_a(0, -1, 0), world, 15, false);
        StringTextComponent message = new StringTextComponent("BOSS FIGHT!");
        message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        RewardsUtil.setNearPlayersTitle(world, pos, 50, STitlePacket.Type.TITLE, (ITextComponent)message, 10, 500, 0);
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_1", 120){

            @Override
            public void callback() {
                StringTextComponent message = new StringTextComponent("");
                message.func_150257_a(player.func_145748_c_());
                StringBuilder sbSpace = new StringBuilder();
                sbSpace.append(" VS ");
                for (int i = 0; i < BossBaseReward.this.bossName.length(); ++i) {
                    sbSpace.append(" ");
                }
                message.func_150258_a(sbSpace.toString());
                message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                RewardsUtil.setNearPlayersTitle(world, pos, 50, STitlePacket.Type.SUBTITLE, (ITextComponent)message, 0, 500, 0);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_2", 160){

            @Override
            public void callback() {
                StringTextComponent message = new StringTextComponent("");
                message.func_150257_a(player.func_145748_c_());
                message.func_150258_a(" VS ");
                message.func_150258_a(BossBaseReward.this.bossName);
                message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                RewardsUtil.setNearPlayersTitle(world, pos, 50, STitlePacket.Type.SUBTITLE, (ITextComponent)message, 0, 100, 10);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_start", 200){

            @Override
            public void callback() {
                BossBaseReward.this.startBossFight(world, pos, player, settings);
            }
        });
    }

    public void startBossFight(final World world, final BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        this.spawnBoss(world, pos, player, settings);
        Scheduler.scheduleTask(new Task("boss_fight_tracker", -1, 5){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                Entity ent;
                int i;
                for (i = BossBaseReward.this.trackedEntities.size() - 1; i >= 0; --i) {
                    ent = (Entity)BossBaseReward.this.trackedEntities.get(i);
                    if (ent.func_70089_S() || ent.field_70173_aa <= 0) continue;
                    BossBaseReward.this.trackedEntities.remove(i);
                    if (!BossBaseReward.this.trackedEntities.isEmpty()) continue;
                    BossBaseReward.this.endBossfight(true, world, pos, player);
                    Scheduler.removeTask(this);
                }
                for (i = BossBaseReward.this.trackedPlayers.size() - 1; i >= 0; --i) {
                    ent = (Entity)BossBaseReward.this.trackedPlayers.get(i);
                    if (ent.func_70092_e((double)BossBaseReward.this.rewardCenterPos.func_177958_n(), (double)BossBaseReward.this.rewardCenterPos.func_177956_o(), (double)BossBaseReward.this.rewardCenterPos.func_177952_p()) > 225.0 || ent.field_70163_u < (double)(BossBaseReward.this.rewardCenterPos.func_177956_o() - 1)) {
                        ent.func_70634_a((double)BossBaseReward.this.rewardCenterPos.func_177958_n(), (double)(BossBaseReward.this.rewardCenterPos.func_177956_o() + 1), (double)BossBaseReward.this.rewardCenterPos.func_177952_p());
                    }
                    if (ent.func_70089_S() || ent.field_70173_aa <= 0) continue;
                    for (Entity entity : BossBaseReward.this.trackedEntities) {
                        entity.func_70106_y();
                    }
                    BossBaseReward.this.trackedEntities.clear();
                    BossBaseReward.this.endBossfight(false, world, pos, player);
                    Scheduler.removeTask(this);
                    return;
                }
            }
        });
    }

    public void endBossfight(boolean resetPlayer, World world, BlockPos pos, PlayerEntity player) {
        for (Entity ent : this.trackedSubEntities) {
            if (!ent.func_70089_S()) continue;
            ent.func_70106_y();
        }
        this.trackedSubEntities.clear();
        this.onBossFightEnd(world, pos, player);
        this.domeGen.removeDome(resetPlayer);
    }

    protected void trackEntities(Entity ... ents) {
        this.trackedEntities.addAll(Arrays.asList(ents));
    }

    protected void trackSubEntities(Entity ... ents) {
        this.trackedSubEntities.addAll(Arrays.asList(ents));
    }

    protected void trackedPlayers(PlayerEntity ... player) {
        this.trackedPlayers.addAll(Arrays.asList(player));
    }

    public abstract void spawnBoss(World var1, BlockPos var2, PlayerEntity var3, Map<String, Object> var4);

    public abstract void onBossFightEnd(World var1, BlockPos var2, PlayerEntity var3);

    public double getBossHealthDynamic(PlayerEntity player, Map<String, Object> settings) {
        double maxDamage = 3.0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            Multimap atributes = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack);
            if (!atributes.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) continue;
            Collection damageList = atributes.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.func_111164_d())) continue;
                maxDamage = damage.func_111164_d();
            }
        }
        double prePofileHealth = maxDamage * 15.0;
        double profileMult = super.getSettingAsDouble(settings, "boss_health_multiplier", 1.0, 0.0, 10.0);
        return prePofileHealth * profileMult;
    }

    public ItemStack getHighestDamageItem(PlayerEntity player) {
        double maxDamage = -1.0;
        ItemStack maxItem = ItemStack.field_190927_a;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            Multimap atributes = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack);
            if (!atributes.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) continue;
            Collection damageList = atributes.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.func_111164_d())) continue;
                maxDamage = damage.func_111164_d();
                maxItem = stack;
            }
        }
        return maxItem;
    }
}

