/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class BossBlazeReward
extends BossBaseReward {
    public BossBlazeReward() {
        super("demonic_blaze");
    }

    @Override
    public void spawnBoss(final World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        final BlazeEntity blaze = (BlazeEntity)EntityType.field_200792_f.func_200721_a(world);
        blaze.func_200203_b((ITextComponent)new StringTextComponent("Demonic Blaze"));
        blaze.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        blaze.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBossHealthDynamic(player, settings));
        blaze.func_70606_j(blaze.func_110138_aP());
        Scheduler.scheduleTask(new Task("blaze_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!blaze.func_70089_S()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.goInvisible(blaze);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.setGroundOnFire(world, player.func_180425_c());
                }
                if (RewardsUtil.rand.nextInt(3) == 4) {
                    BossBlazeReward.this.shootFireballs(world, blaze, player);
                }
            }
        });
        world.func_217376_c((Entity)blaze);
        super.trackEntities(new Entity[]{blaze});
        super.trackedPlayers(player);
    }

    private void goInvisible(BlazeEntity blaze) {
        blaze.func_195064_c(new EffectInstance(Effects.field_76441_p, 5));
    }

    private void setGroundOnFire(World world, BlockPos playerPos) {
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int zOff = -1; zOff <= 1; ++zOff) {
                BlockPos offPos = playerPos.func_177982_a(xOff, 0, zOff);
                RewardsUtil.placeBlock(Blocks.field_150480_ab.func_176223_P(), world, offPos);
            }
        }
    }

    private void shootFireballs(World world, BlazeEntity blaze, PlayerEntity player) {
        double d1 = player.field_70165_t - blaze.field_70165_t;
        double d2 = player.func_174813_aQ().field_72338_b + (double)(player.func_213302_cg() / 2.0f) - (blaze.field_70163_u + (double)(blaze.func_213302_cg() / 2.0f));
        double d3 = player.field_70161_v - blaze.field_70161_v;
        for (int i = 0; i < 5; ++i) {
            SmallFireballEntity entitysmallfireball = new SmallFireballEntity(world, (LivingEntity)blaze, d1 + blaze.func_70681_au().nextGaussian(), d2, d3 + blaze.func_70681_au().nextGaussian());
            entitysmallfireball.field_70163_u = blaze.field_70163_u + (double)(blaze.func_213302_cg() / 2.0f) + 0.5;
            world.func_217376_c((Entity)entitysmallfireball);
        }
    }

    @Override
    public void onBossFightEnd(World world, BlockPos pos, PlayerEntity player) {
    }
}

