/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BossRavagerReward
extends BossBaseReward {
    public BossRavagerReward() {
        super("ravager");
    }

    @Override
    public void spawnBoss(final World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        final RavagerEntity ravager = (RavagerEntity)EntityType.field_220352_aU.func_200721_a(world);
        ravager.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        ravager.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBossHealthDynamic(player, settings) * 2.0);
        ravager.func_70606_j(ravager.func_110138_aP());
        ArmorStandEntity armorStandEntity = (ArmorStandEntity)EntityType.field_200789_c.func_200721_a(world);
        armorStandEntity.func_184224_h(true);
        armorStandEntity.func_184205_a((Entity)ravager, true);
        ItemStack headStack = new ItemStack((IItemProvider)Items.field_196184_dx);
        CompoundNBT nbt = headStack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            headStack.func_77982_d(nbt);
        }
        nbt.func_74778_a("SkullOwner", player.func_200200_C_().getString());
        armorStandEntity.func_184201_a(EquipmentSlotType.HEAD, headStack);
        armorStandEntity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151163_ad));
        armorStandEntity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151173_ae));
        armorStandEntity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151012_L));
        armorStandEntity.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!ravager.func_70089_S()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(20) == 4) {
                    BossRavagerReward.this.groundPound(ravager.func_180425_c(), world);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossRavagerReward.this.charge(ravager, player);
                }
            }
        });
        world.func_217376_c((Entity)ravager);
        super.trackEntities(new Entity[]{ravager});
        super.trackedPlayers(player);
    }

    private void groundPound(final BlockPos ravagerPos, final World world) {
        Scheduler.scheduleTask(new Task("ground_pound_ability", -1, 5){
            int radius;
            {
                super(name, delay, updateTick);
                this.radius = 3;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, -1, 0);
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        pos.func_181079_c(x, -1, z);
                        if (!BossRavagerReward.this.withinDistance((Vec3i)pos, this.radius)) continue;
                        BlockPos newPos = ravagerPos.func_177971_a((Vec3i)pos);
                        BlockState state = world.func_180495_p(newPos);
                        if (CCubesSettings.nonReplaceableBlocks.contains(state) || state.func_177230_c().equals(Blocks.field_150350_a)) {
                            state = Blocks.field_150346_d.func_176223_P();
                        } else {
                            world.func_175656_a(newPos, Blocks.field_150350_a.func_176223_P());
                        }
                        BlockFallingCustom block = new BlockFallingCustom(world, (double)newPos.func_177958_n() + 0.5, newPos.func_177956_o(), (double)newPos.func_177952_p() + 0.5, state, newPos.func_177956_o(), new OffsetBlock(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p(), state, false));
                        block.field_145812_b = 1;
                        block.func_213293_j(0.0, 0.33f, 0.0);
                        world.func_217376_c((Entity)block);
                    }
                }
                ++this.radius;
                if (this.radius == 9) {
                    Scheduler.removeTask(this);
                }
            }
        });
    }

    private void charge(RavagerEntity ravager, PlayerEntity player) {
        BlockPos dist = player.func_180425_c().func_177973_b((Vec3i)ravager.func_180425_c());
        double unit = Math.sqrt(dist.func_177951_i((Vec3i)BlockPos.field_177992_a));
        BlockPos move = new BlockPos((double)dist.func_177958_n() / unit * 3.0, 0.0, (double)dist.func_177952_p() / unit * 3.0);
        ravager.func_213293_j((double)move.func_177958_n(), 0.0, (double)move.func_177952_p());
    }

    @Override
    public void onBossFightEnd(World world, BlockPos pos, PlayerEntity player) {
    }

    public boolean withinDistance(Vec3i pos, double rad) {
        double dist = pos.func_218140_a(0.0, 0.0, 0.0, false);
        return dist < rad * rad && dist >= (rad - 1.0) * (rad - 1.0);
    }
}

