/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Level;

public class BossWitchReward
extends BossBaseReward {
    private List<String> entities = Arrays.asList("creeper", "skeleton", "blaze", "enderman", "endermite", "zombie_pigman", "silverfish", "slime", "spider", "zombie");

    public BossWitchReward() {
        super("evil_witch");
    }

    @Override
    public void spawnBoss(final World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        final WitchEntity witch = (WitchEntity)EntityType.field_200759_ay.func_200721_a(world);
        witch.func_200203_b((ITextComponent)new StringTextComponent("Evil Witch"));
        witch.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        witch.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBossHealthDynamic(player, settings));
        witch.func_70606_j(witch.func_110138_aP());
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151024_Q);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.HEAD, stack);
        witch.func_184642_a(EquipmentSlotType.HEAD, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151027_R);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.CHEST, stack);
        witch.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151026_S);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.LEGS, stack);
        witch.func_184642_a(EquipmentSlotType.LEGS, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151021_T);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.FEET, stack);
        witch.func_184642_a(EquipmentSlotType.FEET, 0.0f);
        this.spawnMinoins(pos, world);
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!witch.func_70089_S()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(15) == 4) {
                    BossWitchReward.this.spawnMinoins(witch.func_180425_c(), world);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossWitchReward.this.lightningStrike(player.func_180425_c(), world);
                }
                if (RewardsUtil.rand.nextInt(5) == 4) {
                    BossWitchReward.this.throwPotion(witch, player.func_180425_c(), world);
                }
            }
        });
        world.func_217376_c((Entity)witch);
        super.trackEntities(new Entity[]{witch});
        super.trackedPlayers(player);
    }

    private void lightningStrike(BlockPos playerPos, World world) {
        ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), false));
    }

    private void throwPotion(WitchEntity witch, BlockPos playerPos, World world) {
        PotionEntity pot = new PotionEntity(world, (LivingEntity)witch);
        pot.func_184541_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)RewardsUtil.getRandomPotionType()));
        double d0 = (double)playerPos.func_177956_o() + 0.5;
        double d1 = (double)playerPos.func_177958_n() - witch.field_70165_t;
        double d2 = d0 - pot.field_70163_u;
        double d3 = (double)playerPos.func_177952_p() - witch.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        pot.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        world.func_217376_c((Entity)pot);
    }

    private void spawnMinoins(BlockPos pos, World world) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            try {
                Optional entType = EntityType.func_220327_a((String)this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())));
                Entity ent = entType.isPresent() ? ((EntityType)entType.get()).func_200721_a(world) : EntityType.field_200797_k.func_200721_a(world);
                BlockPos adjPos = pos.func_177972_a(facing);
                ent.func_70107_b((double)adjPos.func_177958_n(), (double)adjPos.func_177956_o(), (double)adjPos.func_177952_p());
                world.func_217376_c(ent);
                this.trackSubEntities(ent);
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Uh oh! Something went wrong and the minions could not be spawned! Please report this to the mod dev!");
                return;
            }
        }
    }

    @Override
    public void onBossFightEnd(World world, BlockPos pos, PlayerEntity player) {
    }
}

