/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.parsers.RewardParser;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class StreamerReward {
    private Socket socket;
    private BufferedWriter writter;
    private String channel;
    private boolean connectedToChat = false;
    private List<String> voted = new ArrayList<String>();
    private List<Option> options = new ArrayList<Option>();
    private int timeLeft;

    public StreamerReward(String channel, JsonArray jsonOptions) {
        this.channel = "#" + channel;
        for (JsonElement option : jsonOptions) {
            String display = option.getAsJsonObject().get("display").getAsString();
            JsonObject reward = option.getAsJsonObject().getAsJsonObject("reward");
            Iterator iterator = reward.getAsJsonObject().entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = (Map.Entry)iterator.next();
            BaseCustomReward theReward = ((String)entry.getKey()).equals("chat_invades") ? new ChatInvadeReward(channel) : (BaseCustomReward)RewardParser.parseReward(entry).getKey();
            this.options.add(new Option(display, theReward, 0));
        }
    }

    public boolean trigger(final World world, BlockPos pos, final PlayerEntity player) {
        try {
            if (!this.connectedToChat) {
                this.initTwitchChatconnection();
            }
        }
        catch (Exception e) {
            player.func_145747_a((ITextComponent)new StringTextComponent("An issue has occurred with this reward! Code: 0x545749544348"));
            e.printStackTrace();
            return false;
        }
        this.timeLeft = 45;
        this.voted.clear();
        for (Option opt : this.options) {
            opt.votes = 0;
        }
        Scheduler.scheduleTask(new Task("Streamer_Reward", -1, 20){
            int step;
            {
                super(name, delay, updateTick);
                this.step = 0;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                ++this.step;
                switch (this.step) {
                    case 1: {
                        StringTextComponent message = new StringTextComponent("Hey Twitch Chat!");
                        message.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
                        RewardsUtil.setPlayerTitle(player, STitlePacket.Type.TITLE, (ITextComponent)message, 10, 60, 10);
                        break;
                    }
                    case 6: {
                        StringTextComponent message = new StringTextComponent("Let's Play A Game!");
                        message.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
                        RewardsUtil.setPlayerTitle(player, STitlePacket.Type.TITLE, (ITextComponent)message, 10, 60, 10);
                        break;
                    }
                    case 11: {
                        StringTextComponent message = new StringTextComponent("Decide My Fate!");
                        message.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
                        RewardsUtil.setPlayerTitle(player, STitlePacket.Type.TITLE, (ITextComponent)message, 10, 60, 10);
                    }
                }
                if (this.step > 15) {
                    StreamerReward.this.updateTitle(player);
                    StreamerReward.this.timeLeft--;
                }
                if (StreamerReward.this.timeLeft == 0) {
                    Scheduler.removeTask(this);
                    Option winner = (Option)StreamerReward.this.options.get(0);
                    for (Option opt : StreamerReward.this.options) {
                        if (opt.votes <= winner.votes) continue;
                        winner = opt;
                    }
                    player.func_145747_a((ITextComponent)new StringTextComponent(winner.display + " Has won!"));
                    winner.reward.trigger(world, player.func_180425_c(), player, new HashMap<String, Object>());
                    StreamerReward.this.disconnect();
                }
            }
        });
        return true;
    }

    private void initTwitchChatconnection() throws IOException {
        this.socket = new Socket("irc.chat.twitch.tv", 6667);
        this.writter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.connectedToChat = true;
        Thread thread = new Thread(() -> {
            block9: {
                try {
                    String line;
                    InputStreamReader inputStreamReader = new InputStreamReader(this.socket.getInputStream());
                    BufferedReader breader = new BufferedReader(inputStreamReader);
                    block8: while ((line = breader.readLine()) != null && this.connectedToChat) {
                        int firstSpace = line.indexOf(" ");
                        int secondSpace = line.indexOf(" ", firstSpace + 1);
                        if (secondSpace < 0) continue;
                        String from = line.substring(0, firstSpace);
                        String code = line.substring(firstSpace + 1, secondSpace);
                        String rest = line.substring(secondSpace + 1);
                        switch (code) {
                            case "PRIVMSG": {
                                String message;
                                if (this.voted.contains(from) || !IntVar.isInteger(message = rest.substring(rest.indexOf(" ") + 2))) break;
                                int choice = Integer.parseInt(message) - 1;
                                if (choice < 0 || choice >= 5) continue block8;
                                ++this.options.get((int)choice).votes;
                                this.voted.add(from);
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block9;
                    e.printStackTrace();
                }
            }
            this.disconnect();
        });
        this.sendString("PASS PASSWORD");
        this.sendString("NICK justinfan2349");
        this.sendString("JOIN " + this.channel);
        thread.start();
        try {
            HTTPUtil.getWebFile("POST", "http://api.theprogrammingturkey.com/chance_cubes/triggerStreamerReward.php", new CustomEntry<String, String>("channel", this.channel));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "FAILED TO TRIGGER THE CHAT BOT!");
            e.printStackTrace();
        }
    }

    private void disconnect() {
        this.connectedToChat = false;
        try {
            this.socket.close();
            this.writter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateTitle(PlayerEntity player) {
        StringBuilder sb = new StringBuilder();
        for (Option option : this.options) {
            sb.append(option.votes).append(" - ");
        }
        sb.delete(sb.length() - 2, sb.length());
        StringTextComponent message = new StringTextComponent(sb.toString());
        message.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
        RewardsUtil.setPlayerTitle(player, STitlePacket.Type.TITLE, (ITextComponent)message, 0, 40, 0);
        message = new StringTextComponent("Time Left: " + this.timeLeft);
        message.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
        RewardsUtil.setPlayerTitle(player, STitlePacket.Type.SUBTITLE, (ITextComponent)message, 0, 40, 0);
    }

    private void sendString(String str) {
        try {
            if (this.writter == null || !this.connectedToChat) {
                this.initTwitchChatconnection();
            }
            this.writter.write(str + "\r\n");
            this.writter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ChatInvadeReward
    extends BaseCustomReward {
        private String channel;

        public ChatInvadeReward(String channel) {
            super("chatInvades", 0);
            this.channel = channel;
        }

        @Override
        public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
            try {
                JsonObject json = HTTPUtil.getWebFile("GET", "http://tmi.twitch.tv/group/user/" + this.channel.substring(1) + "/chatters", new CustomEntry[0]).getAsJsonObject();
                for (Map.Entry entry : json.get("chatters").getAsJsonObject().entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    for (JsonElement user : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        ZombieEntity zombie;
                        if (!user.isJsonPrimitive() || (zombie = (ZombieEntity)EntityType.field_200725_aD.func_200721_a(world)) == null) continue;
                        zombie.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        zombie.func_200203_b((ITextComponent)new StringTextComponent(user.getAsString()));
                        zombie.func_174805_g(true);
                        world.func_217376_c((Entity)zombie);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class Option {
        public String display;
        public BaseCustomReward reward;
        public int votes;

        public Option(String display, BaseCustomReward reward, int votes) {
            this.display = display;
            this.reward = reward;
            this.votes = votes;
        }
    }
}

