/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CommandRewardType
extends BaseRewardType<CommandPart> {
    public CommandRewardType(CommandPart ... commands) {
        super(commands);
    }

    public CommandRewardType(String ... commands) {
        super(CommandRewardType.convertToCommandParts(commands));
    }

    private static CommandPart[] convertToCommandParts(String ... commands) {
        CommandPart[] toReturn = new CommandPart[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            toReturn[i] = new CommandPart(commands[i]);
        }
        return toReturn;
    }

    @Override
    public void trigger(final CommandPart command, final World world, final int x, final int y, final int z, final PlayerEntity player) {
        Scheduler.scheduleTask(new Task("Command Reward Delay", command.getDelay()){

            @Override
            public void callback() {
                int copies = command.getCopies().getIntValue() + 1;
                String commandStr = command.getParsedCommand(world, x, y, z, player);
                for (int i = 0; i < copies; ++i) {
                    RewardsUtil.executeCommand(world, player, (Vec3i)new BlockPos(x, y, z), commandStr);
                }
            }
        });
    }
}

