/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.sounds;

import chanceCubes.util.FileUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class CustomSoundsLoader {
    private File folder;
    private File dir;
    private File zip;
    private String name;
    private String mcmeta;
    private List<CustomFile> customsSounds = new ArrayList<CustomFile>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public CustomSoundsLoader(File folder, File directory, String packName) {
        this.folder = folder;
        this.dir = directory;
        this.zip = new File(this.dir.getAbsolutePath() + ".zip");
        this.name = packName;
        this.mcmeta = String.format("{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}", this.name);
    }

    public void addCustomSounds() {
        JsonObject root = new JsonObject();
        for (File f : new File(this.folder.getAbsolutePath() + "/sounds").listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".ogg"))) {
            String simpleName = f.getName().substring(0, f.getName().indexOf(46));
            this.customsSounds.add(new CustomFile("assets/minecraft/sounds", f));
            JsonObject event = new JsonObject();
            event.addProperty("category", "block");
            JsonArray sounds = new JsonArray();
            JsonObject soundsObj = new JsonObject();
            soundsObj.addProperty("name", simpleName);
            soundsObj.addProperty("stream", Boolean.valueOf(false));
            sounds.add((JsonElement)soundsObj);
            event.add("sounds", (JsonElement)sounds);
            root.add(simpleName, (JsonElement)event);
        }
        this.customsSounds.add(new CustomFile("assets/minecraft", FileUtil.writeToFile(this.folder.getAbsolutePath() + "/sounds/sounds.json", gson.toJson((JsonElement)root))));
    }

    public void assemble() {
        FileUtil.safeDeleteDirectory(this.dir);
        this.dir.mkdirs();
        String pathToDir = this.dir.getAbsolutePath();
        File metaFile = new File(pathToDir + "/pack.mcmeta");
        try {
            FileUtil.writeNewFile(metaFile, this.mcmeta);
            for (CustomFile custom : this.customsSounds) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
            FileUtil.zipFolderContents(this.dir, this.zip);
            FileUtil.safeDeleteDirectory(this.dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CustomFile {
        private String ext;
        private File file;

        private CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

