/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.CCubesCore;
import chanceCubes.client.ClientProxy;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.commands.RewardArgument;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomProfileLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;

public class CCubesServerCommands {
    public CCubesServerCommands(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"chancecubes").requires(cs -> cs.func_197022_f() instanceof ServerPlayerEntity)).then(Commands.func_197057_a((String)"reload").executes(this::executeReload))).then(Commands.func_197057_a((String)"version").executes(this::executeVersion))).then(Commands.func_197057_a((String)"handNBT").executes(this::executeHandNBT))).then(Commands.func_197057_a((String)"handID").executes(this::executeHandID))).then(Commands.func_197057_a((String)"disableReward").then(Commands.func_197056_a((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeDisableReward((CommandContext<CommandSource>)ctx, RewardArgument.func_212592_a((CommandContext<CommandSource>)ctx, "rewardName")))))).then(Commands.func_197057_a((String)"enableReward").then(Commands.func_197056_a((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeEnableReward((CommandContext<CommandSource>)ctx, RewardArgument.func_212592_a((CommandContext<CommandSource>)ctx, "rewardName")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"schematic").requires(cs -> cs.func_197034_c(2))).requires(cs -> cs.func_197023_e().field_72995_K)).then(Commands.func_197057_a((String)"create").executes(this::executeSchematicCreate))).then(Commands.func_197057_a((String)"cancel").executes(this::executeSchematicCancel)))).then(Commands.func_197057_a((String)"rewardsInfo").executes(this::executeRewardInfo))).then(Commands.func_197057_a((String)"test").executes(this::executeTest))).then(Commands.func_197057_a((String)"testRewards").executes(this::executeTestRewards))).then(Commands.func_197057_a((String)"testCustomRewards").executes(this::executeTestCustomRewards))).then(Commands.func_197057_a((String)"spawnGiantCube").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> this.executeSpawnGiantCube((CommandContext<CommandSource>)ctx, BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"profiles").requires(cs -> cs.func_197023_e().field_72995_K)).executes(this::executeProfilesView)));
    }

    public ServerPlayerEntity getPlayer(CommandSource source) {
        try {
            return source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            CCubesCore.logger.log(Level.ERROR, "You should never see this. If you do you broke everything. Report to Turkey");
            return null;
        }
    }

    public int executeReload(CommandContext<CommandSource> ctx) {
        new Thread(() -> {
            GlobalCCRewardRegistry.DEFAULT.ClearRewards();
            GlobalCCRewardRegistry.GIANT.ClearRewards();
            GlobalProfileManager.clearProfiles();
            ConfigLoader.reload();
            DefaultRewards.loadDefaultRewards();
            DefaultGiantRewards.loadDefaultRewards();
            CustomRewardsLoader.instance.loadCustomRewards();
            GlobalCCRewardRegistry.loadCustomUserRewards(ServerLifecycleHooks.getCurrentServer());
            NonreplaceableBlockOverride.loadOverrides();
            GlobalProfileManager.initProfiles();
            CustomProfileLoader.instance.loadProfiles();
            GlobalProfileManager.updateProfilesForWorld(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_));
            this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Rewards Reloaded"));
        }).start();
        return 0;
    }

    public int executeVersion(CommandContext<CommandSource> ctx) {
        String ver = ((ModContainer)ModList.get().getModContainerById("chancecubes").get()).getModInfo().getVersion().toString();
        this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Chance Cubes Version " + ver));
        return 0;
    }

    public int executeHandNBT(CommandContext<CommandSource> ctx) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        CompoundNBT nbt = player.field_71071_by.func_70448_g().func_196082_o();
        player.func_145747_a((ITextComponent)new StringTextComponent(nbt.toString()));
        return 0;
    }

    public int executeHandID(CommandContext<CommandSource> ctx) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b()) {
            ResourceLocation res = stack.func_77973_b().getRegistryName();
            player.func_145747_a((ITextComponent)new StringTextComponent(res.func_110624_b() + ":" + res.func_110623_a()));
            player.func_145747_a((ITextComponent)new StringTextComponent("meta: " + stack.func_77952_i()));
        }
        return 0;
    }

    public int executeDisableReward(CommandContext<CommandSource> ctx, String reward) {
        return 0;
    }

    public int executeEnableReward(CommandContext<CommandSource> ctx, String reward) {
        return 0;
    }

    public int executeSchematicCreate(CommandContext<CommandSource> ctx) {
        if (RenderEvent.isCreatingSchematic()) {
            if (SchematicUtil.selectionPoints[0] != null && SchematicUtil.selectionPoints[1] != null) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.openSchematicCreatorGUI((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource())));
            } else {
                this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Please set both points before moving on!"));
            }
        } else {
            RenderEvent.setCreatingSchematic(true);
        }
        return 0;
    }

    public int executeSchematicCancel(CommandContext<CommandSource> ctx) {
        RenderEvent.setCreatingSchematic(false);
        SchematicUtil.selectionPoints[0] = null;
        SchematicUtil.selectionPoints[1] = null;
        return 0;
    }

    public int executeRewardInfo(CommandContext<CommandSource> ctx) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        List<PlayerRewardInfo> defaultrewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
        List<PlayerRewardInfo> giantrewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
        int defaultEnabled = defaultrewards.size();
        int giantEnabled = giantrewards.size();
        player.func_145747_a((ITextComponent)new StringTextComponent("===DEFAULT REWARDS==="));
        for (String reward : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(reward));
        }
        this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("There are currently " + GlobalCCRewardRegistry.DEFAULT.getNumberOfLoadedRewards() + " regular rewards loaded and you have " + defaultEnabled + " rewards enabled"));
        this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("There are currently " + GlobalCCRewardRegistry.GIANT.getNumberOfLoadedRewards() + " giant rewards loaded and you have " + giantEnabled + " rewards enabled"));
        return 0;
    }

    public int executeTestRewards(CommandContext<CommandSource> ctx) {
        CCubesSettings.testRewards = !CCubesSettings.testRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testRewards) {
            this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Reward testing is now enabled for all rewards!"));
        } else {
            this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Reward testing is now disabled and normal randomness is back."));
        }
        return 0;
    }

    public int executeTestCustomRewards(CommandContext<CommandSource> ctx) {
        CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testCustomRewards) {
            this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Reward testing is now enabled for custom rewards!"));
        } else {
            this.getPlayer((CommandSource)ctx.getSource()).func_145747_a((ITextComponent)new StringTextComponent("Reward testing is now disabled and normal randomness is back."));
        }
        return 0;
    }

    public int executeTest(CommandContext<CommandSource> ctx) {
        return 0;
    }

    public int executeSpawnGiantCube(CommandContext<CommandSource> ctx, BlockPos pos) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        World world = player.func_130014_f_();
        if (RewardsUtil.isBlockUnbreakable(world, pos.func_177982_a(0, 0, 0)) && CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos.func_177982_a(0, 0, 0)))) {
            return 0;
        }
        GiantCubeUtil.setupStructure(pos.func_177982_a(-1, -1, -1), world, true);
        world.func_184133_a(null, pos, CCubesSounds.GIANT_CUBE_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return 0;
    }

    public int executeProfilesView(CommandContext<CommandSource> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.openProfilesGUI());
        return 0;
    }
}

