/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry.player;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.items.ItemChancePendant;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.StreamerReward;
import chanceCubes.util.RewardsUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class PlayerCCRewardRegistry {
    private List<PlayerRewardInfo> sortedRewards = Lists.newArrayList();
    private List<IChanceCubeReward> cooldownList = new ArrayList<IChanceCubeReward>();
    public static Map<UUID, StreamerReward> streamerReward = new HashMap<UUID, StreamerReward>();

    public boolean enableReward(String reward) {
        if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(reward)) {
            return this.enableReward(GlobalCCRewardRegistry.DEFAULT.getRewardByName(reward));
        }
        if (GlobalCCRewardRegistry.GIANT.isValidRewardName(reward)) {
            return this.enableReward(GlobalCCRewardRegistry.GIANT.getRewardByName(reward));
        }
        return false;
    }

    public boolean enableReward(IChanceCubeReward reward) {
        if (reward != null) {
            int i;
            for (i = 0; i < this.sortedRewards.size() && this.sortedRewards.get(i).getChanceValue() <= reward.getChanceValue(); ++i) {
                if (!this.sortedRewards.get((int)i).reward.getName().equals(reward.getName())) continue;
                return false;
            }
            this.sortedRewards.add(i, new PlayerRewardInfo(reward));
            return true;
        }
        return false;
    }

    public boolean disableReward(String reward) {
        if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(reward)) {
            return this.disableReward(GlobalCCRewardRegistry.DEFAULT.getRewardByName(reward));
        }
        if (GlobalCCRewardRegistry.GIANT.isValidRewardName(reward)) {
            return this.disableReward(GlobalCCRewardRegistry.GIANT.getRewardByName(reward));
        }
        return false;
    }

    public boolean disableReward(IChanceCubeReward reward) {
        for (int i = this.sortedRewards.size() - 1; i >= 0; --i) {
            if (this.sortedRewards.get((int)i).reward != reward) continue;
            return this.sortedRewards.remove(i) != null;
        }
        return false;
    }

    public void setRewardChanceValue(String rewardName, int chance) {
        PlayerRewardInfo reward = this.getRewardByName(rewardName);
        if (reward != null) {
            reward.setRewardChanceValue(chance);
        }
    }

    public void resetRewardChanceValue(String rewardName, int chanceFrom) {
        PlayerRewardInfo reward = this.getRewardByName(rewardName);
        if (reward != null) {
            reward.resetRewardChanceValue(chanceFrom);
        }
    }

    private PlayerRewardInfo getRewardByName(String name) {
        for (PlayerRewardInfo rewardInfo : this.sortedRewards) {
            if (!rewardInfo.reward.getName().equals(name)) continue;
            return rewardInfo;
        }
        return null;
    }

    public void triggerRandomReward(World world, BlockPos pos, @Nonnull PlayerEntity player, int chance) {
        if (streamerReward.containsKey(player.func_110124_au()) && RewardsUtil.rand.nextInt(100) == 42) {
            streamerReward.get(player.func_110124_au()).trigger(world, pos, player);
            return;
        }
        if (CCubesSettings.testRewards) {
            CCubesCore.logger.log(Level.INFO, "This feature has been temporarily removed!");
            return;
        }
        if (CCubesSettings.testCustomRewards) {
            CCubesCore.logger.log(Level.INFO, "This feature has been temporarily removed!");
            return;
        }
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with ChanceCubes and no reward was able to be given");
            return;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemChancePendant)) continue;
            ItemChancePendant pendant = (ItemChancePendant)stack.func_77973_b();
            pendant.damage(stack);
            if (stack.func_77952_i() >= (Integer)CCubesSettings.pendantUses.get()) {
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if ((chance += pendant.getChanceIncrease()) <= 100) break;
            chance = 100;
            break;
        }
        int lowerIndex = 0;
        int upperIndex = this.sortedRewards.size() - 1;
        int lowerRange = Math.max(chance - (Integer)CCubesSettings.rangeMin.get(), -100);
        int upperRange = Math.min(chance + (Integer)CCubesSettings.rangeMax.get(), 100);
        while (this.sortedRewards.get(lowerIndex).getChanceValue() < lowerRange) {
            if (++lowerIndex < this.sortedRewards.size()) continue;
            --lowerIndex;
            break;
        }
        while (this.sortedRewards.get(upperIndex).getChanceValue() > upperRange) {
            if (--upperIndex >= 0) continue;
            ++upperIndex;
            break;
        }
        int range = upperIndex - lowerIndex > 0 ? upperIndex - lowerIndex : 1;
        int pick = RewardsUtil.rand.nextInt(range) + lowerIndex;
        IChanceCubeReward pickedReward = this.sortedRewards.get((int)pick).reward;
        if (this.cooldownList.contains(pickedReward)) {
            for (int atempts = 0; atempts < 5 && this.cooldownList.contains(pickedReward); atempts = (int)((byte)(atempts + 1))) {
                pick = RewardsUtil.rand.nextInt(range) + lowerIndex;
                pickedReward = this.sortedRewards.get((int)pick).reward;
            }
        }
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + pickedReward.getName());
        this.triggerReward(pickedReward, world, pos, player);
        this.cooldownList.add(pickedReward);
        if (this.cooldownList.size() > 15) {
            this.cooldownList.remove(0);
        }
    }

    public void triggerReward(IChanceCubeReward reward, World world, BlockPos pos, PlayerEntity player) {
        Map<String, Object> settings = GlobalProfileManager.getPlayerProfileManager(player).getRewardSpawnSettings(reward);
        reward.trigger(world, pos, player, settings);
    }

    public List<PlayerRewardInfo> getPlayersRewards() {
        return new ArrayList<PlayerRewardInfo>(this.sortedRewards);
    }
}

