/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.ArmorStandArmorReward;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BookOfMemesReward;
import chanceCubes.rewards.defaultRewards.BossBlazeReward;
import chanceCubes.rewards.defaultRewards.BossMimicReward;
import chanceCubes.rewards.defaultRewards.BossRavagerReward;
import chanceCubes.rewards.defaultRewards.BossWitchReward;
import chanceCubes.rewards.defaultRewards.CakeIsALieReward;
import chanceCubes.rewards.defaultRewards.ChanceCubeRenameReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CoinFlipReward;
import chanceCubes.rewards.defaultRewards.CountDownReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.CursedHeadReward;
import chanceCubes.rewards.defaultRewards.DidYouKnowReward;
import chanceCubes.rewards.defaultRewards.DigBuildReward;
import chanceCubes.rewards.defaultRewards.DoubleRainbow;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.ItemChestReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.ItemRenamer;
import chanceCubes.rewards.defaultRewards.JukeBoxReward;
import chanceCubes.rewards.defaultRewards.MagicFeetReward;
import chanceCubes.rewards.defaultRewards.MatchingReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.MazeReward;
import chanceCubes.rewards.defaultRewards.MobTowerReward;
import chanceCubes.rewards.defaultRewards.MontyHallReward;
import chanceCubes.rewards.defaultRewards.OneIsLuckyReward;
import chanceCubes.rewards.defaultRewards.QuestionsReward;
import chanceCubes.rewards.defaultRewards.RainingCatsAndCogsReward;
import chanceCubes.rewards.defaultRewards.SkyblockReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.TableFlipReward;
import chanceCubes.rewards.defaultRewards.TicTacToeReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.defaultRewards.WolvesToCreepersReward;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.CommandRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.rewards.rewardtype.SoundRewardType;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class DefaultRewards {
    public static void loadDefaultRewards() {
        RewardsUtil.initData();
        if (!((Boolean)CCubesSettings.enableHardCodedRewards.get()).booleanValue()) {
            return;
        }
        for (String fileName : RewardsUtil.getHardcodedRewards()) {
            JsonObject json = RewardsUtil.getRewardJson(fileName);
            for (Map.Entry reward : json.entrySet()) {
                CustomEntry<BasicReward, Boolean> parsedReward = RewardParser.parseReward(reward);
                BasicReward basicReward = parsedReward.getKey();
                if (basicReward == null) {
                    CCubesCore.logger.log(Level.ERROR, "A hard coded reward failed to parse! Please report this to the mod dev! " + (String)reward.getKey() + " for the file " + fileName);
                    continue;
                }
                if (parsedReward.getValue().booleanValue()) {
                    GlobalCCRewardRegistry.GIANT.registerReward(basicReward);
                    continue;
                }
                GlobalCCRewardRegistry.DEFAULT.registerReward(basicReward);
            }
        }
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:lava_ring", -40, new BlockRewardType(new OffsetBlock(1, -1, 0, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:rain", -5, new CommandRewardType("/weather thunder 20000")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:silverfish_surround", -20, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 0, Blocks.field_196687_dd, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fish_dog", 20, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_196086_aW, 5)), new ItemPart(new ItemStack((IItemProvider)Items.field_196176_de)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:bone_cat", 20, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_151103_aS, 5)), new ItemPart(new ItemStack((IItemProvider)Items.field_196123_cL)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_cat", -25, new CommandRewardType("/summon ocelot ~ ~1 ~ {CatType:0,Sitting:0,Passengers:[{id:\"tnt\",Fuse:80}]}")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:diamond_block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150484_ah, true, 200))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, -1, 0, Blocks.field_150484_ah, false), new OffsetBlock(1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(-1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, 1, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, -1, Blocks.field_150484_ah, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fake_tnt", 0, new SoundRewardType(new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187539_bB, 120).setAtPlayersLocation(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:invisible_ghasts", 0, new SoundRewardType(new SoundPart(SoundEvents.field_189105_bM).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:no", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, (Block)CCubesBlocks.CHANCE_CUBE, false)), new MessageRewardType("No")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:coal_to_diamonds", 10, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150402_ci, false), new OffsetBlock(0, -1, 0, Blocks.field_150402_ci, false), new OffsetBlock(1, 0, 0, Blocks.field_150402_ci, false), new OffsetBlock(-1, 0, 0, Blocks.field_150402_ci, false), new OffsetBlock(0, 0, 1, Blocks.field_150402_ci, false), new OffsetBlock(0, 0, -1, Blocks.field_150402_ci, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5)), new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_151045_i, 5), 50))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:one_man_army", -10, new EntityRewardType("zombie_pigman"), new CommandRewardType(RewardsUtil.executeXCommands("/summon zombie_pigman ~ ~ ~ {Silent:1,ActiveEffects:[{Id:14,Amplifier:0,Duration:19980,ShowParticles:1b}]}", 9)), new MessageRewardType(new MessagePart("One man army").setRange(32))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:arrow_trap", -25, new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/arrow_trap.ccs", true, new IntVar(1), new IntVar(-1), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:trampoline", 15, new MessageRewardType("Time to bounce!"), new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/trampoline.ccs", true, new IntVar(1), new IntVar(-3), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0))), new BlockRewardType(new OffsetBlock(2, -2, -2, Blocks.field_150451_bX, false, 3).setRelativeToPlayer(true).setCausesBlockUpdate(true), new OffsetBlock(2, -2, -2, Blocks.field_150488_af, false, 5).setRelativeToPlayer(true).setCausesBlockUpdate(true))));
        SignTileEntity sign = new SignTileEntity();
        sign.field_145915_a[0] = new StringTextComponent("The broken path");
        sign.field_145915_a[1] = new StringTextComponent("to succeed");
        CompoundNBT nbt = new CompoundNBT();
        sign.func_189515_b(nbt);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:path_to_succeed", 0, new BlockRewardType(new OffsetBlock[]{new OffsetTileEntity(0, 0, -5, Blocks.field_222384_bX, nbt, true, 20), new OffsetBlock(0, -1, 0, Blocks.field_150347_e, true, 0), new OffsetBlock(0, -1, -1, Blocks.field_150347_e, true, 4), new OffsetBlock(0, -1, -2, Blocks.field_150347_e, true, 8), new OffsetBlock(0, -1, -3, Blocks.field_150347_e, true, 12), new OffsetBlock(0, -1, -4, Blocks.field_150347_e, true, 16), new OffsetBlock(0, -1, -5, Blocks.field_150347_e, true, 20)})));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.field_150339_S, true, i * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, Blocks.field_150461_bJ, true, 200);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:beacon_build", 100, new BlockRewardType(blocks)));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:half_heart", -30){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                player.func_70606_j(1.0f);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:no_exp", -40){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                player.field_71068_ca = 0;
                player.field_71067_cb = 0;
                player.field_71106_cc = 0.0f;
                player.func_145747_a((ITextComponent)new StringTextComponent("Rip EXP"));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:smite", -10){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                if (world.field_72995_K) {
                    return;
                }
                ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), false));
                player.func_145747_a((ITextComponent)new StringTextComponent("Thou has been smitten!"));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:cookie-splosion", 35){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        ItemEntity cookie = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151106_aX));
                        world.func_217376_c((Entity)cookie);
                        cookie.func_213293_j(xx, Math.random(), zz);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_status_effect", 0){

            @Override
            public void trigger(World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Selecting random potion effect to apply..."));
                Scheduler.scheduleTask(new Task("Cookie Monster", 30){

                    @Override
                    public void callback() {
                        EffectInstance effect = RewardsUtil.getRandomPotionEffectInstance();
                        player.func_145747_a((ITextComponent)new StringTextComponent("You have been given: "));
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(effect.func_76453_d(), new Object[0]));
                        player.func_145747_a((ITextComponent)new StringTextComponent("for " + effect.func_76459_b() / 20 + " seconds!"));
                        player.func_195064_c(effect);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:arrow_spray", -15){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        ArrowEntity arrow = new ArrowEntity(world, (LivingEntity)player);
                        arrow.func_70012_b((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p(), 0.0f, 0.0f);
                        arrow.func_213293_j(xx, 0.3, zz);
                        world.func_217376_c((Entity)arrow);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:lingering_potions_ring", -10){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (double rad = -Math.PI; rad <= Math.PI; rad += 0.3141592653589793) {
                    PotionEntity pot = new PotionEntity(world, (LivingEntity)player);
                    pot.func_184541_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)RewardsUtil.getRandomPotionType()));
                    pot.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    pot.func_213293_j(Math.cos(rad) * 0.25, 1.0, Math.sin(rad) * 0.25);
                    world.func_217376_c((Entity)pot);
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:charged_creeper", -40){

            @Override
            public void trigger(final World world, final BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
                if (world.field_72995_K) {
                    return;
                }
                RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(0, 1, 0));
                final CreeperEntity ent = (CreeperEntity)EntityType.field_200797_k.func_200721_a(world);
                ent.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                ent.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, 99, true, false));
                ent.func_195064_c(new EffectInstance(Effects.field_76426_n, 300, 99, true, false));
                world.func_217376_c((Entity)ent);
                Scheduler.scheduleTask(new Task("Charged Creeper Reward", 2){

                    @Override
                    public void callback() {
                        ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        ent.func_70015_d(0);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:disco", 40){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (int xx = -4; xx < 5; ++xx) {
                    for (int zz = -4; zz < 5; ++zz) {
                        RewardsUtil.placeBlock(RewardsUtil.getRandomWool(), world, pos.func_177982_a(xx, -1, zz));
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    SheepEntity sheep = (SheepEntity)EntityType.field_200737_ac.func_200721_a(world);
                    sheep.func_200203_b((ITextComponent)new StringTextComponent("jeb_"));
                    sheep.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0f, 0.0f);
                    world.func_217376_c((Entity)sheep);
                }
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.func_176223_P(), world, pos.func_177982_a(0, 3, 0));
                RewardsUtil.sendMessageToNearPlayers(world, pos, 32, "Disco Party!!!!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:ender_crystal_timer", -90){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (int i = 30; i > 0; --i) {
                    RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(0, i, 0));
                }
                EnderCrystalEntity ent = (EnderCrystalEntity)EntityType.field_200801_o.func_200721_a(world);
                ent.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_217376_c((Entity)ent);
                ArrowEntity arrow = new ArrowEntity(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 29), (double)pos.func_177952_p() + 0.5);
                arrow.func_213293_j(0.0, -0.25, 0.0);
                world.func_217376_c((Entity)arrow);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:5_prongs", -10){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (int xx = pos.func_177958_n() - 3; xx <= pos.func_177958_n() + 3; ++xx) {
                    for (int zz = pos.func_177952_p() - 3; zz <= pos.func_177952_p() + 3; ++zz) {
                        for (int yy = pos.func_177956_o(); yy <= pos.func_177956_o() + 4; ++yy) {
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, new BlockPos(xx, yy, zz));
                        }
                    }
                }
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos);
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(0, 1, 0));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.func_176223_P(), world, pos.func_177982_a(0, 2, 0));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(-3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(-3, 1, -3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(-3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(-3, 1, 3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(3, 1, -3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(3, 1, 3));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:inventory_bomb", -55){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                int i;
                player.field_71071_by.func_70436_m();
                for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    player.field_71071_by.field_70462_a.set(i, (Object)new ItemStack((IItemProvider)Blocks.field_196555_aI, 64));
                }
                for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                    ItemStack stack = new ItemStack((IItemProvider)Blocks.field_196555_aI, 64);
                    if (i == 0) {
                        stack.func_200302_a(new StringTextComponent("Button").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                        stack.func_190920_e(13);
                    } else if (i == 1) {
                        stack.func_200302_a((ITextComponent)new StringTextComponent("TheBlackswordsman"));
                        stack.func_190920_e(13);
                    }
                    player.field_71071_by.field_70460_b.set(i, (Object)stack);
                }
                player.func_145747_a((ITextComponent)new StringTextComponent("Inventory Bomb!!!!"));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:nuke", -75){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                RewardsUtil.sendMessageToNearPlayers(world, pos, 32, "May death rain upon them");
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), (LivingEntity)player));
                world.func_217376_c((Entity)new TNTEntity(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), (LivingEntity)player));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_teleport", -15){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                int xChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177958_n() - 35;
                int zChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177952_p() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= world.func_72940_L(); ++yy) {
                    if (!world.func_175623_d(new BlockPos(xChange, yy, zChange)) || !world.func_175623_d(new BlockPos(xChange, yy + 1, zChange))) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.func_70634_a((double)xChange, (double)yChange, (double)zChange);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:rotten_food", -30){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r()) continue;
                    player.field_71071_by.field_70462_a.set(i, (Object)new ItemStack((IItemProvider)Items.field_151078_bh, stack.func_190916_E()));
                }
                player.func_145747_a((ITextComponent)new StringTextComponent("Ewwww it's all rotten"));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:thrown_in_air", -35){

            @Override
            public void trigger(World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
                int px = (int)Math.floor(player.func_226277_ct_());
                int py = (int)Math.floor(player.func_226278_cu_()) + 1;
                int pz = (int)Math.floor(player.func_226281_cx_());
                for (int y = 0; y < 40; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(px + x, py + y, pz + z));
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("Thrown_In_Air_Reward", 5){

                    @Override
                    public void callback() {
                        player.field_70160_al = true;
                        player.func_213293_j(0.0, 20.0, 0.0);
                        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:torches_to_creepers", -40){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                for (int yy = -32; yy <= 32; ++yy) {
                    for (int xx = -32; xx <= 32; ++xx) {
                        for (int zz = -32; zz <= 32; ++zz) {
                            BlockState b = world.func_180495_p(pos.func_177982_a(xx, yy, zz));
                            if (b.getLightValue((IBlockReader)world, pos) <= 0 || b.func_177230_c() == Blocks.field_150353_l || b.func_177230_c().hasTileEntity(b)) continue;
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(xx, yy, zz));
                            CreeperEntity creeper = (CreeperEntity)EntityType.field_200797_k.func_200721_a(world);
                            creeper.func_70012_b((double)(pos.func_177958_n() + xx) + 0.5, (double)(pos.func_177956_o() + yy), (double)(pos.func_177952_p() + zz) + 0.5, 0.0f, 0.0f);
                            world.func_217376_c((Entity)creeper);
                        }
                    }
                }
                player.func_145747_a((ITextComponent)new StringTextComponent("Those lights seem a little weird.... O.o"));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:traveller", 15){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                int x = RewardsUtil.rand.nextInt(1000) + 200;
                int z = RewardsUtil.rand.nextInt(1000) + 200;
                BlockPos newPos = pos.func_177982_a(x, 0, z);
                RewardsUtil.placeBlock((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.WEST), world, newPos);
                ChestTileEntity chest = (ChestTileEntity)world.func_175625_s(newPos);
                for (int i = 0; i < 10; ++i) {
                    chest.func_70299_a(i, new ItemStack((IItemProvider)RewardsUtil.getRandomItem()));
                }
                RewardsUtil.sendMessageToNearPlayers(world, pos, 25, "" + newPos.func_177958_n() + ", " + newPos.func_177956_o() + ", " + newPos.func_177952_p());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:troll_hole", -20){

            @Override
            public void trigger(World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
                BlockPos worldPos = new BlockPos(Math.floor(player.func_226277_ct_()), Math.floor(player.func_226278_cu_()) - 1.0, Math.floor(player.func_226281_cx_()));
                final RewardBlockCache cache = new RewardBlockCache(world, worldPos, new BlockPos(worldPos.func_177958_n(), worldPos.func_177956_o() + 1, worldPos.func_177952_p()));
                for (int y = 0; y > -75; --y) {
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            cache.cacheBlock(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("TrollHole", 35){

                    @Override
                    public void callback() {
                        cache.restoreBlocks((Entity)player);
                        player.field_70143_R = 0.0f;
                        player.func_213293_j(0.0, 0.0, 0.0);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:saw_nothing_diamond", 0){

            @Override
            public void trigger(World world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
                final ItemEntity itemEnt = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151045_i, 1));
                itemEnt.func_174871_r();
                world.func_217376_c((Entity)itemEnt);
                Scheduler.scheduleTask(new Task("Saw_Nothing_Diamond", 100){

                    @Override
                    public void callback() {
                        itemEnt.func_70106_y();
                        player.func_145747_a((ITextComponent)new StringTextComponent("You didn't see anything......"));
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:hand_enchant", 20){

            @Override
            public void trigger(World world, BlockPos pos, PlayerEntity player, Map<String, Object> settings) {
                ItemStack toEnchant;
                if (!player.func_184614_ca().func_190926_b()) {
                    toEnchant = player.func_184614_ca();
                } else {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        if (stack.func_190926_b()) continue;
                        stacks.add(stack);
                    }
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        if (stack.func_190926_b()) continue;
                        stacks.add(stack);
                    }
                    if (stacks.size() == 0) {
                        ItemStack dirt = new ItemStack((IItemProvider)Blocks.field_150346_d);
                        dirt.func_200302_a((ITextComponent)new StringTextComponent("A lonley piece of dirt"));
                        player.field_71071_by.func_70441_a(dirt);
                        RewardsUtil.executeCommand(world, player, (Vec3i)player.func_180425_c(), "/advancement grant @p only chancecubes:lonely_dirt");
                        return;
                    }
                    toEnchant = (ItemStack)stacks.get(RewardsUtil.rand.nextInt(stacks.size()));
                }
                CustomEntry<Enchantment, Integer> enchantment = RewardsUtil.getRandomEnchantmentAndLevel();
                toEnchant.func_77966_a(enchantment.getKey(), enchantment.getValue().intValue());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new AnvilRain());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new HerobrineReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CreeperSurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WitherReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TrollTNTReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WaitForItReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ClearInventoryReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemOfDestinyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new JukeBoxReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BookOfMemesReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TableFlipReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new OneIsLuckyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SkyblockReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CakeIsALieReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemRenamer());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DoubleRainbow());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WolvesToCreepersReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DidYouKnowReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ArmorStandArmorReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new RainingCatsAndCogsReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemChestReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MagicFeetReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DigBuildReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ChanceCubeRenameReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CountDownReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MobTowerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MontyHallReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MatchingReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TicTacToeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossMimicReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossWitchReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossBlazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossRavagerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CursedHeadReward());
        MathReward math = new MathReward();
        MinecraftForge.EVENT_BUS.register((Object)math);
        GlobalCCRewardRegistry.DEFAULT.registerReward(math);
        QuestionsReward question = new QuestionsReward();
        MinecraftForge.EVENT_BUS.register((Object)question);
        GlobalCCRewardRegistry.DEFAULT.registerReward(question);
        CoinFlipReward coinFlip = new CoinFlipReward();
        MinecraftForge.EVENT_BUS.register((Object)coinFlip);
        GlobalCCRewardRegistry.DEFAULT.registerReward(coinFlip);
    }
}

