/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.BaseBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicTreesBiome
extends BaseBiome {
    public BasicTreesBiome(String name) {
        super(name);
    }

    @Override
    public Block getFloorBlock() {
        return Blocks.field_196658_i;
    }

    @Override
    public void getRandomGenBlock(float dist, Random rand, int x, int y, int z, List<OffsetBlock> blocks, int delay) {
        if (y != 0) {
            return;
        }
        if (dist < 0.0f && rand.nextInt(5) == 0) {
            OffsetBlock osb = new OffsetBlock(x, y + 1, z, Blocks.field_150349_c, false, delay / 10);
            osb.setBlockState(Blocks.field_150349_c.func_176223_P());
            blocks.add(osb);
        } else if (dist < -5.0f && rand.nextInt(100) == 0) {
            List<OffsetBlock> treeblocks = this.addTree(x, y, z, delay / 10);
            blocks.addAll(treeblocks);
        }
    }

    public List<OffsetBlock> addTree(int x, int y, int z, int delay) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (int yy = 1; yy < 6; ++yy) {
            blocks.add(new OffsetBlock(x, y + yy, z, Blocks.field_196617_K, false, delay));
            ++delay;
        }
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 0; yy < 2; ++yy) {
                    if (xx == 0 && zz == 0) continue;
                    blocks.add(new OffsetBlock(x + xx, y + 4 + yy, z + zz, Blocks.field_196642_W, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(x + 1, y + 6, z, Blocks.field_196642_W, false, delay));
        blocks.add(new OffsetBlock(x - 1, y + 6, z, Blocks.field_196642_W, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z + 1, Blocks.field_196642_W, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z - 1, Blocks.field_196642_W, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z, Blocks.field_196642_W, false, ++delay));
        return blocks;
    }

    @Override
    public void spawnEntities(BlockPos center, World world) {
        for (int i = 0; i < RewardsUtil.rand.nextInt(10) + 5; ++i) {
            int ri = RewardsUtil.rand.nextInt(5);
            if (ri == 0) {
                ChickenEntity chicken = (ChickenEntity)EntityType.field_200795_i.func_200721_a(world);
                chicken.func_70012_b((double)(center.func_177958_n() + (RewardsUtil.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (RewardsUtil.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_217376_c((Entity)chicken);
                continue;
            }
            if (ri == 1) {
                CowEntity cow = (CowEntity)EntityType.field_200796_j.func_200721_a(world);
                cow.func_70012_b((double)(center.func_177958_n() + (RewardsUtil.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (RewardsUtil.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_217376_c((Entity)cow);
                continue;
            }
            if (ri == 2) {
                HorseEntity horse = (HorseEntity)EntityType.field_200762_B.func_200721_a(world);
                horse.func_70012_b((double)(center.func_177958_n() + (RewardsUtil.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (RewardsUtil.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_217376_c((Entity)horse);
                continue;
            }
            if (ri == 3) {
                PigEntity pig = (PigEntity)EntityType.field_200784_X.func_200721_a(world);
                pig.func_70012_b((double)(center.func_177958_n() + (RewardsUtil.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (RewardsUtil.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_217376_c((Entity)pig);
                continue;
            }
            if (ri != 4) continue;
            SheepEntity sheep = (SheepEntity)EntityType.field_200737_ac.func_200721_a(world);
            sheep.func_70012_b((double)(center.func_177958_n() + (RewardsUtil.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (RewardsUtil.rand.nextInt(31) - 15)), 0.0f, 0.0f);
            world.func_217376_c((Entity)sheep);
        }
    }
}

