/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OffsetTileEntity
extends OffsetBlock {
    private NBTVar teNBT;

    public OffsetTileEntity(int x, int y, int z, Block b, CompoundNBT te, boolean falling, int delay) {
        this(x, y, z, b.func_176223_P(), te, falling, delay);
    }

    public OffsetTileEntity(int x, int y, int z, BlockState state, CompoundNBT te, boolean falling) {
        this(x, y, z, state, te, falling, 0);
    }

    public OffsetTileEntity(int x, int y, int z, BlockState state, CompoundNBT te, BoolVar falling) {
        this(new IntVar(x), new IntVar(y), new IntVar(z), state, new NBTVar(te), falling, new IntVar(0));
    }

    public OffsetTileEntity(int x, int y, int z, BlockState state, CompoundNBT te, boolean falling, int delay) {
        this(new IntVar(x), new IntVar(y), new IntVar(z), state, new NBTVar(te), new BoolVar(falling), new IntVar(delay));
    }

    public OffsetTileEntity(IntVar x, IntVar y, IntVar z, BlockState state, NBTVar te, BoolVar falling, IntVar delay) {
        super(x, y, z, state, falling, delay);
        this.teNBT = te;
    }

    @Override
    public void spawnInWorld(final World world, final int x, final int y, final int z, final RewardBlockCache blockCache) {
        if (!this.falling.getBoolValue().booleanValue()) {
            Scheduler.scheduleTask(new Task("Delayed_Block", this.getDelay()){

                @Override
                public void callback() {
                    OffsetTileEntity.this.placeInWorld(world, new BlockPos(x, y, z), true, blockCache);
                }
            });
        } else {
            Scheduler.scheduleTask(new Task("Falling_TileEntity", this.getDelay()){

                @Override
                public void callback() {
                    OffsetTileEntity.this.spawnFallingBlock(world, x, y, z, blockCache);
                }
            });
        }
    }

    @Override
    public BlockPos placeInWorld(World world, BlockPos placeLoc, boolean offset, RewardBlockCache blockCache) {
        BlockPos pos = super.placeInWorld(world, placeLoc, offset, blockCache);
        TileEntity te = TileEntity.func_203403_c((CompoundNBT)this.teNBT.getNBTValue());
        if (!offset) {
            pos = placeLoc;
        }
        te.func_174878_a(pos);
        world.func_175690_a(pos, te);
        return pos;
    }
}

