/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityRewardType
extends BaseRewardType<EntityPart> {
    public EntityRewardType(EntityPart ... entities) {
        super(entities);
    }

    public EntityRewardType(String ... entities) {
        super(EntityRewardType.convertToEntityParts(entities));
    }

    private static EntityPart[] convertToEntityParts(String ... entities) {
        EntityPart[] toReturn = new EntityPart[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            toReturn[i] = new EntityPart(EntityRewardType.getBasicNBTForEntity(entities[i]));
        }
        return toReturn;
    }

    @Override
    public void trigger(final EntityPart part, final World world, final int x, final int y, final int z, PlayerEntity player) {
        Scheduler.scheduleTask(new Task("Entity Reward Delay", part.getDelay()){

            @Override
            public void callback() {
                if (part.shouldRemovedBlocks()) {
                    for (int yy = 0; yy < 4; ++yy) {
                        for (int xx = -1; xx < 2; ++xx) {
                            for (int zz = -1; zz < 2; ++zz) {
                                RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, new BlockPos(x + xx, y + yy, z + zz));
                            }
                        }
                    }
                }
                int copies = part.getCopies().getIntValue() + 1;
                for (int i = 0; i < copies; ++i) {
                    Optional opt = EntityType.func_220330_a((CompoundNBT)part.getNBT(), (World)world);
                    if (!opt.isPresent()) {
                        CCubesCore.logger.log(Level.ERROR, "Invalid entity NBT! " + part.getNBT().toString());
                        return;
                    }
                    Entity newEnt = (Entity)opt.get();
                    newEnt.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
                    world.func_217376_c(newEnt);
                }
            }
        });
    }

    public static CompoundNBT getBasicNBTForEntity(String entity) {
        CompoundNBT nbt;
        String json = "{id:" + entity + "}";
        try {
            nbt = JsonToNBT.func_180713_a((String)json);
        }
        catch (CommandSyntaxException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to create a simple NBTTagCompound from " + entity);
            return null;
        }
        return nbt;
    }
}

