/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.FileUtil;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class RewardsUtil {
    private static List<String> oredicts = new ArrayList<String>();
    private static String[] possibleModOres = new String[]{"ores/aluminum", "ores/copper", "ores/mythril", "ores/lead", "ores/plutonium", "ores/quartz", "ores/ruby", "ores/salt", "ores/sapphire", "ores/silver", "ores/tin", "ores/uranium", "ores/zinc"};
    public static final Random rand = new Random();
    private static final Block[] wools = new Block[]{Blocks.field_196556_aL, Blocks.field_196557_aM, Blocks.field_196558_aN, Blocks.field_196559_aO, Blocks.field_196561_aQ, Blocks.field_196562_aR, Blocks.field_196563_aS, Blocks.field_196564_aT, Blocks.field_196565_aU, Blocks.field_196566_aV, Blocks.field_196567_aW, Blocks.field_196568_aX, Blocks.field_196569_aY, Blocks.field_196570_aZ, Blocks.field_196602_ba};

    public static List<String> getOreDicts() {
        return oredicts;
    }

    public static void initData() {
        oredicts.add("ores/gold");
        oredicts.add("ores/iron");
        oredicts.add("ores/lapis");
        oredicts.add("ores/diamond");
        oredicts.add("ores/redstone");
        oredicts.add("ores/emerald");
        oredicts.add("ores/quartz");
        oredicts.add("ores/coal");
        for (String oreDict : possibleModOres) {
            if (BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", oreDict)) == null) continue;
            oredicts.add(oreDict);
        }
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(World world, BlockPos pos, int distance, String message) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            PlayerEntity entityplayer = (PlayerEntity)world.func_217369_A().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.func_226277_ct_(), 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.func_226278_cu_(), 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.func_226281_cx_(), 2.0));
            if (!(dist <= (double)distance)) continue;
            entityplayer.func_145747_a((ITextComponent)new StringTextComponent(message));
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            PlayerEntity entityplayer = (PlayerEntity)world.func_217369_A().get(i);
            entityplayer.func_145747_a((ITextComponent)new StringTextComponent(message));
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mod, itemName));
        return item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item, size);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, blockName));
    }

    public static boolean placeBlock(BlockState b, World world, BlockPos pos) {
        return RewardsUtil.placeBlock(b, world, pos, 3, false);
    }

    public static boolean placeBlock(BlockState b, World world, BlockPos pos, boolean ignoreUnbreakable) {
        return RewardsUtil.placeBlock(b, world, pos, 3, ignoreUnbreakable);
    }

    public static boolean placeBlock(BlockState b, World world, BlockPos pos, int update, boolean ignoreUnbreakable) {
        if (!RewardsUtil.isBlockUnbreakable(world, pos) || ignoreUnbreakable) {
            world.func_180501_a(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) == -1.0f || CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos));
    }

    public static Enchantment getEnchantSafe(ResourceLocation res) {
        return (Enchantment)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.ENCHANTMENTS, res, ForgeRegistries.ENCHANTMENTS.getDefaultKey());
    }

    public static Effect getPotionSafe(ResourceLocation res) {
        return (Effect)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.POTIONS, res, ForgeRegistries.POTIONS.getDefaultKey());
    }

    public static ParticleType<?> getParticleSafe(ResourceLocation res) {
        return (ParticleType)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.PARTICLE_TYPES, res, ForgeRegistries.PARTICLE_TYPES.getDefaultKey());
    }

    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntrySafe(IForgeRegistry<T> registry, ResourceLocation key, ResourceLocation defaultReturn) {
        IForgeRegistryEntry val = registry.getValue(key);
        return (T)(val == null ? registry.getValue(defaultReturn) : val);
    }

    public static Block getRandomOre() {
        return RewardsUtil.getRandomOre(new ArrayList<String>());
    }

    public static Block getRandomOre(List<String> blacklist) {
        return (Block)BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", RewardsUtil.getRandomOreDict(blacklist))).func_205596_a(rand);
    }

    public static Block getRandomOreFromOreDict(String oreDict) {
        return (Block)BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", oreDict)).func_205596_a(rand);
    }

    public static Block getRandomBlock() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.BLOCKS, Blocks.field_150347_e);
    }

    public static Item getRandomItem() {
        Item item;
        while ((item = RewardsUtil.randomRegistryEntry(ForgeRegistries.ITEMS, Items.field_151034_e)) == null || item.getCreativeTabs().size() == 0) {
        }
        return item;
    }

    public static Enchantment randomEnchantment() {
        return (Enchantment)RewardsUtil.randomRegistryEntry(ForgeRegistries.ENCHANTMENTS, (IForgeRegistryEntry)Registry.field_212628_q.func_186801_a(rand));
    }

    public static CustomEntry<Enchantment, Integer> getRandomEnchantmentAndLevel() {
        Enchantment ench = RewardsUtil.randomEnchantment();
        int level = rand.nextInt(ench.func_77325_b()) + ench.func_77319_d();
        return new CustomEntry<Enchantment, Integer>(ench, level);
    }

    public static Effect getRandomPotionEffect() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.POTIONS, Effects.field_188423_x);
    }

    public static EffectInstance getRandomPotionEffectInstance() {
        Effect effect = RewardsUtil.getRandomPotionEffect();
        int duration = ((int)Math.round(Math.abs(rand.nextGaussian()) * 5.0) + 3) * 20;
        int amplifier = (int)Math.round(Math.abs(rand.nextGaussian() * 1.5));
        return new EffectInstance(effect, duration, amplifier);
    }

    public static Potion getRandomPotionType() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.POTION_TYPES, Potions.field_185229_a);
    }

    public static <T extends IForgeRegistryEntry<T>> T randomRegistryEntry(IForgeRegistry<T> registry, T defaultReturn) {
        Collection entries = registry.getValues();
        IForgeRegistryEntry entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        int iteration = 0;
        while (entry == null) {
            if (++iteration > 100) {
                return defaultReturn;
            }
            entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        }
        return (T)entry;
    }

    public static ItemStack getRandomFirework() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("Flight", rand.nextInt(3) + 1);
        ListNBT explosionList = new ListNBT();
        for (int i = 0; i <= rand.nextInt(2); ++i) {
            CompoundNBT explosionData = new CompoundNBT();
            explosionData.func_74768_a("Type", rand.nextInt(5));
            explosionData.func_74757_a("Flicker", rand.nextBoolean());
            explosionData.func_74757_a("Trail", rand.nextBoolean());
            int[] colors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.func_74783_a("Colors", colors);
            int[] fadeColors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < fadeColors.length; ++j) {
                fadeColors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.func_74783_a("FadeColors", fadeColors);
            explosionList.add((Object)explosionData);
        }
        data.func_218657_a("Explosions", (INBT)explosionList);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Fireworks", (INBT)data);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static String getRandomOreDict() {
        return RewardsUtil.getRandomOreDict(new ArrayList<String>());
    }

    public static String getRandomOreDict(List<String> blacklist) {
        List oredicts = RewardsUtil.getOreDicts().stream().filter(line -> !blacklist.contains(line)).collect(Collectors.toList());
        return oredicts.size() > 0 ? (String)oredicts.get(rand.nextInt(oredicts.size())) : "ores/coal";
    }

    public static Fluid getRandomFluid(boolean onlySources) {
        Fluid fluid;
        do {
            fluid = (Fluid)RewardsUtil.randomRegistryEntry(ForgeRegistries.FLUIDS, Fluids.field_204546_a);
        } while (onlySources && !fluid.func_207193_c(fluid.func_207188_f()));
        return fluid;
    }

    public static int getRandomColor() {
        return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)).getRGB();
    }

    public static BlockState getRandomWool() {
        return wools[rand.nextInt(wools.length)].func_176223_P();
    }

    public static boolean isPlayerOnline(PlayerEntity player) {
        if (player == null) {
            return false;
        }
        for (ServerPlayerEntity playerMP : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
            if (!playerMP.func_110124_au().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    public static void executeCommand(World world, PlayerEntity player, Vec3i pos, String command) {
        RewardsUtil.executeCommand(world, player, new Vec3d(pos), command);
    }

    public static void executeCommand(World world, PlayerEntity player, Vec3d pos, String command) {
        MinecraftServer server = world.func_73046_m();
        ServerWorld worldServer = server.func_71218_a(DimensionType.field_223227_a_);
        boolean rule = worldServer.func_82736_K().func_223586_b(GameRules.field_223605_h);
        ((GameRules.BooleanValue)worldServer.func_82736_K().func_223585_a(GameRules.field_223605_h)).func_223570_a(false, server);
        CommandSource cs = new CommandSource((ICommandSource)player, pos, player.func_189653_aC(), worldServer, 2, player.func_200200_C_().getString(), player.func_145748_c_(), server, (Entity)player);
        cs = cs.func_197031_a();
        server.func_195571_aL().func_197059_a(cs, command);
        ((GameRules.BooleanValue)worldServer.func_82736_K().func_223585_a(GameRules.field_223605_h)).func_223570_a(rule, server);
    }

    public static void setNearPlayersTitle(World world, BlockPos pos, int range, STitlePacket.Type type, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            PlayerEntity entityplayer = (PlayerEntity)world.func_217369_A().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.func_226277_ct_(), 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.func_226278_cu_(), 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.func_226281_cx_(), 2.0));
            if (!(dist <= (double)range)) continue;
            RewardsUtil.setPlayerTitle(entityplayer, type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setAllPlayersTitle(World world, STitlePacket.Type type, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            RewardsUtil.setPlayerTitle((PlayerEntity)world.func_217369_A().get(i), type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setPlayerTitle(PlayerEntity player, STitlePacket.Type type, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        if (player instanceof ServerPlayerEntity) {
            STitlePacket titlePacket = new STitlePacket(type, message, fadeInTime, displayTime, fadeOutTime);
            STitlePacket timesPacket = new STitlePacket(STitlePacket.Type.TIMES, (ITextComponent)new StringTextComponent(""), fadeInTime, displayTime, fadeOutTime);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)timesPacket);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)titlePacket);
        }
    }

    public static String[] getHardcodedRewards() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/rewards.txt")));
            ArrayList<String> files = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                files.add(line);
            }
            in.close();
            return files.toArray(new String[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "CHANCE CUBES WAS UNABLE TO LOAD IN ITS DEFAULT REWARDS!!!!");
            CCubesCore.logger.log(Level.ERROR, "REPORT TO MOD AUTHOR ASAP!!!");
            e.printStackTrace();
            return new String[0];
        }
    }

    public static JsonObject getRewardJson(String file) {
        BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/" + file)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FileUtil.JSON_PARSER.parse(builder.toString()).getAsJsonObject();
    }
}

