/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import owca.coffeemod.init.BlockInit;
import owca.coffeemod.objects.blocks.CoffeeBushBlock;

public class BiomeFeatureProvider {
    public static void addFeatures() {
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            if (biome.func_201856_r() != Biome.Category.PLAINS) continue;
            BiomeFeatureProvider.addFeatureToBiome(biome, GenerationStage.Decoration.VEGETAL_DECORATION, BiomeFeatures.COFFEE_BUSH);
        }
    }

    public static void addFeatureToBiome(Biome biome, GenerationStage.Decoration feature, ConfiguredFeature<?, ?> configuredFeature) {
        BiomeFeatureProvider.ConvertImmutableFeatures(biome);
        List biomeFeatures = biome.func_242440_e().field_242484_f;
        while (biomeFeatures.size() <= feature.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        ((List)biomeFeatures.get(feature.ordinal())).add(() -> configuredFeature);
    }

    private static void ConvertImmutableFeatures(Biome biome) {
        if (biome.func_242440_e().field_242484_f instanceof ImmutableList) {
            biome.func_242440_e().field_242484_f = biome.func_242440_e().field_242484_f.stream().map(Lists::newArrayList).collect(Collectors.toList());
        }
    }

    public static class BiomeFeatures {
        public static ConfiguredFeature<?, ?> COFFEE_BUSH;

        public static ConfiguredFeature<?, ?> newConfiguredFeature(String registryName, ConfiguredFeature<?, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("coffeemod", registryName), configuredFeature);
            return configuredFeature;
        }

        static {
            ConfiguredFeature configuredFeature1 = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)BlockInit.COFFEE_BUSH.get()).func_176223_P().func_206870_a((Property)CoffeeBushBlock.field_176488_a, (Comparable)Integer.valueOf(7))), (BlockPlacer)new CoffeeBushBlock.CoffeeBushBlockPlacer()).func_227315_a_(1).func_227317_b_().func_227322_d_()).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(1);
            COFFEE_BUSH = BiomeFeatures.newConfiguredFeature("coffee_bush", configuredFeature1);
        }
    }
}

