/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owca.coffeemod.gui.DeluxeCoffeeMachineScreen;
import owca.coffeemod.gui.GuiUtil;
import owca.coffeemod.tileentity.CoffeeType;

@OnlyIn(value=Dist.CLIENT)
public class CoffeeButton
extends Button {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("coffeemod:textures/gui/coffee_button.png");
    private final ResourceLocation iconResourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int yDiffTex;
    private final int textureWidth;
    private final int textureHeight;
    private final int iconOffsetX;
    private final int iconOffsetY;
    private final Function<CoffeeType, ButtonStatus> buttonStatusFunction;
    private final Consumer<CoffeeType> onCoffeeHovered;
    private final CoffeeType coffeeType;
    private int tooltipTick = 0;
    private DeluxeCoffeeMachineScreen screen;

    public CoffeeButton(int x, int y, CoffeeType coffeeType, Button.IPressable onPressIn, Function<CoffeeType, ButtonStatus> buttonStatusFunction, Consumer<CoffeeType> onCoffeeHovered, DeluxeCoffeeMachineScreen screen) {
        this(x, y, 24, 24, 0, 0, 24, coffeeType.getIcon(), 4, 3, 24, 72, onPressIn, StringTextComponent.field_240750_d_, buttonStatusFunction, onCoffeeHovered, coffeeType);
        this.screen = screen;
    }

    private CoffeeButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation iconResourceLocation, int iconOffsetX, int iconOffsetY, int p_i232261_9_, int p_i232261_10_, Button.IPressable p_i232261_11_, ITextComponent p_i232261_12_, Function<CoffeeType, ButtonStatus> buttonStatusFunction, Consumer<CoffeeType> onCoffeeHovered, CoffeeType coffeeType) {
        super(x, y, width, height, p_i232261_12_, p_i232261_11_, (p_238488_0_, p_238488_1_, p_238488_2_, p_238488_3_) -> {});
        this.textureWidth = p_i232261_9_;
        this.textureHeight = p_i232261_10_;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffTex = yDiffTex;
        this.iconResourceLocation = iconResourceLocation;
        this.iconOffsetX = iconOffsetX;
        this.iconOffsetY = iconOffsetY;
        this.buttonStatusFunction = buttonStatusFunction;
        this.onCoffeeHovered = onCoffeeHovered;
        this.coffeeType = coffeeType;
    }

    public void tick() {
        this.tooltipTick = this.func_230449_g_() ? ++this.tooltipTick : 0;
    }

    public void func_230443_a_(MatrixStack matrixStack, int p_230443_2_, int p_230443_3_) {
        if (this.tooltipTick > 10) {
            Item item = (Item)this.coffeeType.getItem().get();
            List transform = Lists.transform(GuiUtil.buildCoffeeItemTooltip(item, true), ITextComponent::func_241878_f);
            this.screen.func_238654_b_(matrixStack, transform, p_230443_2_, p_230443_3_);
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.yTexStart;
        if (this.func_230449_g_()) {
            this.onCoffeeHovered.accept(this.coffeeType);
            switch (this.buttonStatusFunction.apply(this.coffeeType)) {
                case AVAILABLE: {
                    i += this.yDiffTex;
                    break;
                }
                case NOT_AVAILABLE: {
                    i += this.yDiffTex * 2;
                    break;
                }
            }
        }
        RenderSystem.enableDepthTest();
        CoffeeButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.xTexStart, (float)i, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
        minecraft.func_110434_K().func_110577_a(this.iconResourceLocation);
        CoffeeButton.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.iconOffsetX), (int)(this.field_230691_m_ + this.iconOffsetY), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        if (this.func_230449_g_()) {
            this.func_230443_a_(matrixStack, p_230431_2_, p_230431_3_);
        }
    }

    public void func_230930_b_() {
        if (this.buttonStatusFunction.apply(this.coffeeType) == ButtonStatus.AVAILABLE) {
            super.func_230930_b_();
        }
    }

    public CoffeeType getCoffeeType() {
        return this.coffeeType;
    }

    public static enum ButtonStatus {
        AVAILABLE,
        NOT_AVAILABLE,
        DISABLED;

    }
}

