/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owca.coffeemod.gui.CoffeeButton;
import owca.coffeemod.gui.IngredientWidget;
import owca.coffeemod.network.ModPacketHandler;
import owca.coffeemod.network.messages.AddIngredientMessage;
import owca.coffeemod.network.messages.MakeCoffeeMessage;
import owca.coffeemod.tileentity.CoffeeType;
import owca.coffeemod.tileentity.DeluxeCoffeeMachineTileEntity;
import owca.coffeemod.tileentity.Ingredient;

@OnlyIn(value=Dist.CLIENT)
public class DeluxeCoffeeMachineScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_RESOURCE_LOCATION = new ResourceLocation("coffeemod:textures/gui/background.png");
    private final BlockPos pos;
    private final Map<Ingredient, Integer> ingredients;
    private CoffeeType hoveredCoffee = null;
    private List<IngredientWidget> ingredientWidgets = new ArrayList<IngredientWidget>();
    private List<CoffeeButton> coffeeButtons = new ArrayList<CoffeeButton>();

    public DeluxeCoffeeMachineScreen(BlockPos pos, Map<Ingredient, Integer> ingredients) {
        super((ITextComponent)new StringTextComponent(""));
        this.pos = pos;
        this.ingredients = ingredients;
    }

    public void func_231160_c_() {
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        this.field_230710_m_.clear();
        this.field_230705_e_.removeIf(c -> c instanceof Button);
        this.coffeeButtons.clear();
        this.ingredientWidgets.clear();
        int i = (this.field_230708_k_ - 256) / 2;
        int j = (this.field_230709_l_ - 256) / 2 + 64;
        this.coffeeButtons.add(new CoffeeButton(i + 80, j + 14, CoffeeType.ESPRESSO, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.add(new CoffeeButton(i + 80, j + 42, CoffeeType.LATTE, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.add(new CoffeeButton(i + 80, j + 70, CoffeeType.FRAPPE, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.add(new CoffeeButton(i + 160, j + 14, CoffeeType.CARAMEL_MACCHIATO, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.add(new CoffeeButton(i + 160, j + 42, CoffeeType.MOCHA, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.add(new CoffeeButton(i + 160, j + 70, CoffeeType.COCOA_DRINK, this.onCoffeeSelected(), this::getButtonStatus, this::onCoffeeHovered, this));
        this.coffeeButtons.forEach(this::addButton);
        Stream.of(Ingredient.values()).forEach(ingredient -> this.ingredientWidgets.add(new IngredientWidget(this, 10, 40 + 21 * ingredient.ordinal(), (Ingredient)((Object)ingredient))));
    }

    void addButton(Button button) {
        super.func_230480_a_((Widget)button);
    }

    private CoffeeButton.ButtonStatus getButtonStatus(CoffeeType coffeeType) {
        boolean hasRequiredIngredients = DeluxeCoffeeMachineTileEntity.hasRequiredIngredients(coffeeType, this.ingredients);
        return hasRequiredIngredients ? CoffeeButton.ButtonStatus.AVAILABLE : CoffeeButton.ButtonStatus.NOT_AVAILABLE;
    }

    public Button.IPressable onIngredientAdd(Ingredient ingredient) {
        return b -> ModPacketHandler.getInstance().sendToServer((Object)new AddIngredientMessage(this.pos, ingredient, 1));
    }

    protected Button.IPressable onCoffeeSelected() {
        return b -> {
            ModPacketHandler.getInstance().sendToServer((Object)new MakeCoffeeMessage(this.pos, ((CoffeeButton)b).getCoffeeType()));
            this.close();
        };
    }

    protected void onCoffeeHovered(CoffeeType coffeeType) {
        this.hoveredCoffee = coffeeType;
    }

    public void func_231164_f_() {
        Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        if (this.ingredientWidgets != null) {
            this.ingredientWidgets.forEach(IngredientWidget::tick);
            this.coffeeButtons.forEach(CoffeeButton::tick);
        }
    }

    private void close() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.close();
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_230446_a_(matrixStack);
        this.drawGuiContainerBackgroundLayer(matrixStack);
        DeluxeCoffeeMachineScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"gui.ingredients", (Object[])new Object[0]) + ":"), (int)20, (int)20, (int)0xFFFFFF);
        this.ingredientWidgets.forEach(widget -> widget.render(matrixStack));
        this.hoveredCoffee = null;
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
    }

    protected void drawGuiContainerBackgroundLayer(MatrixStack matrixStack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_RESOURCE_LOCATION);
        int i = (this.field_230708_k_ - 256) / 2;
        int j = (this.field_230709_l_ - 256) / 2 + 64;
        this.func_238474_b_(matrixStack, i, j, 0, 0, 256, 256);
    }

    public Map<Ingredient, Integer> getIngredients() {
        return this.ingredients;
    }

    public CoffeeType getHoveredCoffee() {
        return this.hoveredCoffee;
    }

    FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

