/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owca.coffeemod.gui.DeluxeCoffeeMachineScreen;
import owca.coffeemod.tileentity.Ingredient;

@OnlyIn(value=Dist.CLIENT)
public class IngredientWidget
extends AbstractGui {
    private static final int RED = 0xAA0000;
    private static final int GREEN = 43520;
    private static final int WHITE = 0xFFFFFF;
    private final DeluxeCoffeeMachineScreen screen;
    private final int x;
    private final int y;
    private final Ingredient ingredient;
    private final Button button;
    private int tooltipTick = 0;

    public IngredientWidget(DeluxeCoffeeMachineScreen screen, int x, int y, Ingredient ingredient) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.ingredient = ingredient;
        this.button = new Button(x + 50, y - 7, 20, 20, (ITextComponent)new StringTextComponent("+"), screen.onIngredientAdd(ingredient), this.onTooltip());
        screen.addButton(this.button);
    }

    private ITextComponent getTooltipText() {
        if (this.button.field_230693_o_) {
            return new TranslationTextComponent("gui.ingredient.add.from.inventory.x.available", new Object[]{this.ingredient.getItem().func_200296_o(), this.getItemCountInInventory(this.ingredient)});
        }
        if (this.screen.getIngredients().get((Object)this.ingredient) >= 20) {
            return new TranslationTextComponent("gui.ingredient.full");
        }
        return new TranslationTextComponent("gui.ingredient.not.enough", new Object[]{this.ingredient.getItem().func_200296_o()});
    }

    private int getItemCountInInventory(Ingredient ingredient) {
        int count = 0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return count;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != ingredient.getItem()) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public void tick() {
        this.tooltipTick = this.button.func_230449_g_() ? ++this.tooltipTick : 0;
    }

    private Button.ITooltip onTooltip() {
        return (p_238659_1_, p_238659_2_, p_238659_3_, p_238659_4_) -> {
            if (this.tooltipTick > 10) {
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                list.add(this.getTooltipText());
                List transform = Lists.transform(list, ITextComponent::func_241878_f);
                this.screen.func_238654_b_(p_238659_2_, transform, p_238659_3_, p_238659_4_);
            }
        };
    }

    public void render(MatrixStack matrixStack) {
        Integer amount = this.screen.getIngredients().get((Object)this.ingredient);
        this.renderIcon(matrixStack, this.ingredient.getIcon(), this.x, this.y - 5);
        int fontColor = 0xFFFFFF;
        if (this.shouldHighlightIngredient(this.ingredient)) {
            fontColor = amount > 0 ? 43520 : 0xAA0000;
        }
        IngredientWidget.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.screen.getFont(), (String)(amount + "/" + 20), (int)(this.x + 17), (int)this.y, (int)fontColor);
        this.button.field_230693_o_ = amount < 20 && this.getItemCountInInventory(this.ingredient) > 0;
    }

    private boolean shouldHighlightIngredient(Ingredient ingredient) {
        if (this.screen.getHoveredCoffee() == null) {
            return false;
        }
        return this.screen.getHoveredCoffee().getIngredients().contains((Object)ingredient);
    }

    private void renderIcon(MatrixStack matrixStack, ResourceLocation resourceLocation, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        IngredientWidget.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
    }
}

