/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.network.messages;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import owca.coffeemod.network.ModPacketHandler;
import owca.coffeemod.network.messages.OpenCoffeeMachineScreenMessage;
import owca.coffeemod.tileentity.DeluxeCoffeeMachineTileEntity;
import owca.coffeemod.tileentity.Ingredient;

public class AddIngredientMessage {
    private final BlockPos pos;
    private final Ingredient ingredient;
    private final int amount;

    public AddIngredientMessage(BlockPos pos, Ingredient ingredient, int amount) {
        this.pos = pos;
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public static AddIngredientMessage readMessageData(PacketBuffer buf) {
        return new AddIngredientMessage(buf.func_179259_c(), (Ingredient)buf.func_179257_a(Ingredient.class), buf.readInt());
    }

    public void writeMessageData(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_179249_a((Enum)this.ingredient);
        buf.writeInt(this.amount);
    }

    public static void handlePacket(AddIngredientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld serverWorld = sender.func_71121_q();
            TileEntity tileEntity = serverWorld.func_175625_s(message.pos);
            if (tileEntity instanceof DeluxeCoffeeMachineTileEntity) {
                DeluxeCoffeeMachineTileEntity deluxeCoffeeMachineTileEntity = (DeluxeCoffeeMachineTileEntity)tileEntity;
                boolean itemFound = false;
                for (int i = 0; i < sender.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = sender.field_71071_by.func_70301_a(i);
                    if (stack.func_77973_b() != message.ingredient.getItem()) continue;
                    stack.func_190918_g(1);
                    if (message.ingredient.shouldReturnBucket()) {
                        sender.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar));
                    }
                    itemFound = true;
                    break;
                }
                if (itemFound) {
                    deluxeCoffeeMachineTileEntity.addIngredient(message.ingredient, message.amount);
                    ModPacketHandler.getInstance().send(PacketDistributor.PLAYER.with(() -> sender), (Object)new OpenCoffeeMachineScreenMessage(message.pos, deluxeCoffeeMachineTileEntity.getIngredients()));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

