/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.network.messages;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import owca.coffeemod.tileentity.CoffeeType;
import owca.coffeemod.tileentity.DeluxeCoffeeMachineTileEntity;

public class MakeCoffeeMessage {
    private final BlockPos pos;
    private final CoffeeType coffeeType;

    public MakeCoffeeMessage(BlockPos pos, CoffeeType coffeeType) {
        this.pos = pos;
        this.coffeeType = coffeeType;
    }

    public static MakeCoffeeMessage readMessageData(PacketBuffer buf) {
        return new MakeCoffeeMessage(buf.func_179259_c(), (CoffeeType)buf.func_179257_a(CoffeeType.class));
    }

    public void writeMessageData(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_179249_a((Enum)this.coffeeType);
    }

    public static void handlePacket(MakeCoffeeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld serverWorld = sender.func_71121_q();
            TileEntity tileEntity = serverWorld.func_175625_s(message.pos);
            if (tileEntity instanceof DeluxeCoffeeMachineTileEntity) {
                ((DeluxeCoffeeMachineTileEntity)tileEntity).startMakingCoffee(message.coffeeType);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

