/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.network.messages;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import owca.coffeemod.gui.DeluxeCoffeeMachineScreen;
import owca.coffeemod.tileentity.Ingredient;
import owca.coffeemod.util.NbtUtil;

public class OpenCoffeeMachineScreenMessage {
    private final BlockPos pos;
    private final Map<Ingredient, Integer> ingredients;

    public OpenCoffeeMachineScreenMessage(BlockPos pos, Map<Ingredient, Integer> ingredients) {
        this.pos = pos;
        this.ingredients = ingredients;
    }

    public static OpenCoffeeMachineScreenMessage readMessageData(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        Map<Ingredient, Integer> ingredients = NbtUtil.stringToIngredients(buf.func_150789_c(Short.MAX_VALUE));
        return new OpenCoffeeMachineScreenMessage(blockPos, ingredients);
    }

    public void writeMessageData(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(NbtUtil.ingredientsToString(this.ingredients));
    }

    public static void handlePacket(OpenCoffeeMachineScreenMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OpenCoffeeMachineScreenMessage.displayScreen(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void displayScreen(OpenCoffeeMachineScreenMessage message) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DeluxeCoffeeMachineScreen(message.pos, message.ingredients));
    }
}

