/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.objects.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import owca.coffeemod.init.BlockInit;
import owca.coffeemod.init.BlockPlacerTypeInit;

public class CoffeeBushBlock
extends CropsBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    private static final List<Block> ALLOWED_SURFACES = ImmutableList.of((Object)Blocks.field_150458_ak, (Object)Blocks.field_196658_i);

    public CoffeeBushBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected IItemProvider func_199772_f() {
        return (IItemProvider)BlockInit.COFFEE_SEED.get();
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)2);
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        this.grow(worldIn, pos, state, this.func_185529_b(worldIn));
    }

    public void grow(World worldIn, BlockPos pos, BlockState state, int amount) {
        BlockPos lowerHalfPos = this.getLowerHalf((IWorldReader)worldIn, state, pos);
        int currentAge = this.func_185527_x(worldIn.func_180495_p(lowerHalfPos));
        int newAge = Math.min(currentAge + amount, this.func_185526_g());
        worldIn.func_180501_a(lowerHalfPos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(newAge))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        if (newAge >= 4) {
            worldIn.func_180501_a(lowerHalfPos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(newAge))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos lowerHalfPos = this.getLowerHalf(worldIn, state, pos);
        return ALLOWED_SURFACES.contains(worldIn.func_180495_p(lowerHalfPos.func_177977_b()).func_177230_c()) && (worldIn.func_226659_b_(lowerHalfPos, 0) >= 8 || worldIn.func_226660_f_(pos));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_() && ((Integer)state.func_177229_b((Property)field_176488_a)).intValue() == this.func_185526_g()) {
                CoffeeBushBlock.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.func_185527_x(state) == this.func_185526_g() && !worldIn.field_72995_K) {
            CoffeeBushBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            this.grow(worldIn, pos, state, -1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private BlockPos getLowerHalf(IWorldReader worldIn, BlockState state, BlockPos pos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (half == DoubleBlockHalf.LOWER) {
            return pos;
        }
        BlockPos lower = pos.func_177977_b();
        if (worldIn.func_180495_p(lower).func_177230_c() == this) {
            return lower;
        }
        return pos;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        Thread.dumpStack();
        return super.func_220076_a(state, builder);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.func_176487_g((World)worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HALF});
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = CoffeeBushBlock.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.grow((World)worldIn, pos, state, 1);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public BlockState getMaxState() {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(this.func_185526_g()))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int age, int flags) {
        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(age)), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(age)), flags);
    }

    public static class CoffeeBushBlockPlacer
    extends BlockPlacer {
        public static final Codec<CoffeeBushBlockPlacer> codec;
        public static final CoffeeBushBlockPlacer placer;

        public void func_225567_a_(IWorld world, BlockPos pos, BlockState state, Random rand) {
            if (rand.nextInt(10) < 4) {
                CoffeeBushBlock coffeeBlock = (CoffeeBushBlock)state.func_177230_c();
                coffeeBlock.placeAt(world, pos, coffeeBlock.func_185526_g(), 2);
            }
        }

        protected BlockPlacerType<?> func_230368_a_() {
            return (BlockPlacerType)BlockPlacerTypeInit.COFFEE_BUSH_PLACER.get();
        }

        static {
            placer = new CoffeeBushBlockPlacer();
            codec = Codec.unit(() -> placer);
        }
    }
}

