/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.objects.blocks;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import owca.coffeemod.init.ItemInit;
import owca.coffeemod.init.ModTileEntityTypes;
import owca.coffeemod.tileentity.CoffeeMachineTileEntity;

public class CoffeeMachineBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public CoffeeMachineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(STATE, (Comparable)((Object)State.IDLE)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.COFFEE_MACHINE.get()).func_200968_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NS;
            }
            case SOUTH: {
                return SHAPE_NS;
            }
            case EAST: {
                return SHAPE_EW;
            }
            case WEST: {
                return SHAPE_EW;
            }
        }
        return SHAPE_EW;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING}).func_206894_a(new Property[]{STATE});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (!worldIn.field_72995_K && this.canMakeCoffee(worldIn, player, pos)) {
            Objects.requireNonNull(this.getCoffeeMachineTileEntity(worldIn, pos)).startMakingCoffee();
            heldItemMainhand.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean canMakeCoffee(World worldIn, PlayerEntity player, BlockPos pos) {
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (heldItemMainhand.func_77973_b() == ItemInit.ROASTED_COFFEE_BEANS.get()) {
            CoffeeMachineTileEntity coffeeMachineTileEntity = this.getCoffeeMachineTileEntity(worldIn, pos);
            return coffeeMachineTileEntity != null && !coffeeMachineTileEntity.isMakingCoffee();
        }
        return false;
    }

    private CoffeeMachineTileEntity getCoffeeMachineTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CoffeeMachineTileEntity) {
            return (CoffeeMachineTileEntity)tileEntity;
        }
        return null;
    }

    public static enum State implements IStringSerializable
    {
        IDLE,
        WORKING;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == IDLE ? "idle" : "working";
        }
    }
}

