/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.objects.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import owca.coffeemod.init.ModTileEntityTypes;
import owca.coffeemod.network.ModPacketHandler;
import owca.coffeemod.network.messages.OpenCoffeeMachineScreenMessage;
import owca.coffeemod.objects.blocks.CoffeeMachineBlock;
import owca.coffeemod.tileentity.DeluxeCoffeeMachineTileEntity;

public class DeluxeCoffeeMachineBlock
extends CoffeeMachineBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<CoffeeMachineBlock.State> STATE = EnumProperty.func_177709_a((String)"state", CoffeeMachineBlock.State.class);

    public DeluxeCoffeeMachineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(STATE, (Comparable)((Object)CoffeeMachineBlock.State.IDLE)));
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.DELUXE_COFFEE_MACHINE.get()).func_200968_a();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        DeluxeCoffeeMachineTileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = this.getCoffeeMachineTileEntity(worldIn, pos)) != null) {
            if (tileEntity.isMakingCoffee()) {
                return ActionResultType.SUCCESS;
            }
            ModPacketHandler.getInstance().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OpenCoffeeMachineScreenMessage(pos, tileEntity.getIngredients()));
        }
        return ActionResultType.SUCCESS;
    }

    private DeluxeCoffeeMachineTileEntity getCoffeeMachineTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof DeluxeCoffeeMachineTileEntity) {
            return (DeluxeCoffeeMachineTileEntity)tileEntity;
        }
        return null;
    }
}

