/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.tileentity;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owca.coffeemod.init.ModTileEntityTypes;
import owca.coffeemod.init.SoundInit;
import owca.coffeemod.objects.blocks.CoffeeMachineBlock;
import owca.coffeemod.objects.blocks.DeluxeCoffeeMachineBlock;
import owca.coffeemod.tileentity.CoffeeType;
import owca.coffeemod.tileentity.Ingredient;
import owca.coffeemod.util.NbtUtil;

public class DeluxeCoffeeMachineTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final int MAX_INGREDIENT_AMOUNT = 20;
    private static final int PREPARATION_TIME = 160;
    public static final String NBT_INGREDIENTS = "ingredients";
    public static final String NBT_TICK = "tick";
    public static final String NBT_COFFEE_TYPE = "coffeeType";
    private int tick;
    private CoffeeType currentCoffeeType = CoffeeType.ESPRESSO;
    private Map<Ingredient, Integer> ingredients = new EnumMap<Ingredient, Integer>(Ingredient.class);

    public DeluxeCoffeeMachineTileEntity() {
        super((TileEntityType)ModTileEntityTypes.DELUXE_COFFEE_MACHINE.get());
        Stream.of(Ingredient.values()).forEach(i -> this.ingredients.put((Ingredient)((Object)i), 0));
    }

    public void func_73660_a() {
        if (this.tick > 0) {
            --this.tick;
            if (this.tick == 0) {
                this.makeCoffee();
            }
        }
    }

    public boolean isMakingCoffee() {
        return this.tick > 0;
    }

    public static boolean hasRequiredIngredients(CoffeeType coffeeType, Map<Ingredient, Integer> ingredients) {
        EnumSet<Ingredient> requiredIngredients = coffeeType.getIngredients();
        return requiredIngredients.stream().allMatch(i -> (Integer)ingredients.get(i) > 0);
    }

    public void startMakingCoffee(CoffeeType coffeeType) {
        if (this.isMakingCoffee()) {
            return;
        }
        EnumSet<Ingredient> requiredIngredients = coffeeType.getIngredients();
        boolean hasRequiredIngredients = requiredIngredients.stream().allMatch(this::hasIngredient);
        if (hasRequiredIngredients) {
            this.currentCoffeeType = coffeeType;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundInit.COFFEE_MACHINE_WORKING.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(DeluxeCoffeeMachineBlock.STATE, (Comparable)((Object)CoffeeMachineBlock.State.WORKING)));
            this.tick = 160;
            requiredIngredients.forEach(this::useIngredient);
        }
    }

    private void makeCoffee() {
        Item coffee = (Item)this.currentCoffeeType.getItem().get();
        Direction direction = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)DeluxeCoffeeMachineBlock.FACING);
        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177971_a(direction.func_176730_m()), (ItemStack)new ItemStack((IItemProvider)coffee));
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(DeluxeCoffeeMachineBlock.STATE, (Comparable)((Object)CoffeeMachineBlock.State.IDLE)));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_TICK, this.tick);
        compound.func_74778_a(NBT_INGREDIENTS, NbtUtil.ingredientsToString(this.ingredients));
        compound.func_74778_a(NBT_COFFEE_TYPE, this.currentCoffeeType.name());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.tick = compound.func_74762_e(NBT_TICK);
        if (compound.func_74764_b(NBT_INGREDIENTS)) {
            this.ingredients = NbtUtil.stringToIngredients(compound.func_74779_i(NBT_INGREDIENTS));
            this.currentCoffeeType = CoffeeType.valueOf(compound.func_74779_i(NBT_COFFEE_TYPE));
        }
    }

    public Map<Ingredient, Integer> getIngredients() {
        return this.ingredients;
    }

    public boolean hasIngredient(Ingredient ingredient) {
        return this.ingredients.get((Object)ingredient) > 0;
    }

    public boolean canAddIngredient(Ingredient ingredient) {
        return this.ingredients.get((Object)ingredient) < 20;
    }

    public void addIngredient(Ingredient ingredient) {
        if (!this.canAddIngredient(ingredient)) {
            return;
        }
        this.ingredients.put(ingredient, Math.min(this.ingredients.get((Object)ingredient) + ingredient.getItemValue(), 20));
    }

    public void addIngredient(Ingredient ingredient, int amount) {
        IntStream.range(0, amount).forEach(i -> {
            if (this.canAddIngredient(ingredient)) {
                this.addIngredient(ingredient);
            }
        });
    }

    public void useIngredient(Ingredient ingredient) {
        if (!this.hasIngredient(ingredient)) {
            return;
        }
        this.ingredients.put(ingredient, this.ingredients.get((Object)ingredient) - 1);
    }
}

