/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod.tileentity;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import owca.coffeemod.init.ItemInit;

public enum Ingredient {
    COFFEE((Item)ItemInit.ROASTED_COFFEE_BEANS.get(), 1, new ResourceLocation("coffeemod:textures/items/roasted_coffee_beans.png")),
    WATER(Items.field_151131_as, 10, new ResourceLocation("textures/item/water_bucket.png"), true),
    MILK(Items.field_151117_aB, 10, new ResourceLocation("textures/item/milk_bucket.png"), true),
    SUGAR(Items.field_151102_aT, 1, new ResourceLocation("textures/item/sugar.png")),
    COCOA(Items.field_196130_bo, 1, new ResourceLocation("textures/item/cocoa_beans.png")),
    SNOW(Items.field_151126_ay, 1, new ResourceLocation("textures/item/snowball.png")),
    CARAMEL((Item)ItemInit.CARAMEL.get(), 1, new ResourceLocation("coffeemod:textures/items/caramel.png"));

    private final Item item;
    private final int itemValue;
    private final ResourceLocation icon;
    private final boolean shouldReturnBucket;

    private Ingredient(Item item, int itemValue, ResourceLocation icon) {
        this(item, itemValue, icon, false);
    }

    private Ingredient(Item item, int itemValue, ResourceLocation icon, boolean shouldReturnBucket) {
        this.item = item;
        this.itemValue = itemValue;
        this.icon = icon;
        this.shouldReturnBucket = shouldReturnBucket;
    }

    public static Optional<Ingredient> findByItem(Item item) {
        return Stream.of(Ingredient.values()).filter(i -> i.item == item).findFirst();
    }

    public Item getItem() {
        return this.item;
    }

    public int getItemValue() {
        return this.itemValue;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public boolean shouldReturnBucket() {
        return this.shouldReturnBucket;
    }
}

