/*
 * Decompiled with CFR 0.152.
 */
package owca.coffeemod;

import net.minecraft.block.Block;
import net.minecraft.world.biome.PlainsBiome;
import net.minecraft.world.biome.SunflowerPlainsBiome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import owca.coffeemod.init.BlockInit;
import owca.coffeemod.init.ItemInit;
import owca.coffeemod.init.ModTileEntityTypes;
import owca.coffeemod.init.SoundInit;
import owca.coffeemod.objects.blocks.CoffeeBushBlock;

@Mod(value="coffeemod")
public class CoffeeMod {
    public static final String MOD_ID = "coffeemod";
    public static CoffeeMod INSTANCE;
    public static final Logger LOGGER;

    public CoffeeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        INSTANCE = this;
        SoundInit.SOUNDS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        ForgeRegistries.BIOMES.forEach(biome -> {
            if (biome instanceof PlainsBiome || biome instanceof SunflowerPlainsBiome) {
                BlockClusterFeatureConfig coffeeConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)BlockInit.COFFEE_BUSH.get()).func_176223_P()), (BlockPlacer)new CoffeeBushBlock.CoffeeBushBlockPlacer()).func_227315_a_(32).func_227317_b_().func_227322_d_();
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)coffeeConfig).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(16))));
            }
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

