/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.client.gui;

import com._idrae.cooking_table.client.gui.CookingTableRecipeBookCategories;
import com._idrae.cooking_table.recipes.CookingTableRecipe;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CookingTableClientRecipeBook
extends RecipeBook {
    private final RecipeManager recipeManager;
    private final Map<CookingTableRecipeBookCategories, List<RecipeList>> recipesByCategory = Maps.newHashMap();
    private final List<RecipeList> allRecipes = Lists.newArrayList();

    public boolean func_193830_f(@Nullable IRecipe<?> recipe) {
        return true;
    }

    public CookingTableClientRecipeBook(RecipeManager p_i48186_1_) {
        this.recipeManager = p_i48186_1_;
    }

    public void rebuildTable() {
        this.allRecipes.clear();
        this.recipesByCategory.clear();
        HashBasedTable table = HashBasedTable.create();
        for (IRecipe irecipe : this.recipeManager.func_199510_b()) {
            RecipeList recipeList;
            if (irecipe.func_192399_d()) continue;
            CookingTableRecipeBookCategories category = CookingTableClientRecipeBook.getCategory(irecipe);
            String s = irecipe.func_193358_e();
            if (s.isEmpty()) {
                recipeList = this.newRecipeList(category);
            } else {
                recipeList = (RecipeList)table.get((Object)category, (Object)s);
                if (recipeList == null) {
                    recipeList = this.newRecipeList(category);
                    table.put((Object)category, (Object)s, (Object)recipeList);
                }
            }
            recipeList.func_192709_a(irecipe);
        }
    }

    private RecipeList newRecipeList(CookingTableRecipeBookCategories category) {
        RecipeList recipeList = new RecipeList();
        this.allRecipes.add(recipeList);
        this.recipesByCategory.computeIfAbsent(category, category1 -> Lists.newArrayList()).add(recipeList);
        if (category == CookingTableRecipeBookCategories.COOKING_TABLE_FOOD) {
            this.addRecipeListToCategory(CookingTableRecipeBookCategories.COOKING_TABLE_SEARCH, recipeList);
        }
        return recipeList;
    }

    private void addRecipeListToCategory(CookingTableRecipeBookCategories categories, RecipeList recipeList) {
        this.recipesByCategory.computeIfAbsent(categories, categories1 -> Lists.newArrayList()).add(recipeList);
    }

    private static CookingTableRecipeBookCategories getCategory(IRecipe<?> recipe) {
        IRecipeType irecipetype = recipe.func_222127_g();
        if (irecipetype == CookingTableRecipe.COOKING || irecipetype == IRecipeType.field_222149_a && (recipe.func_77571_b().func_222117_E() || recipe.func_77571_b().func_77973_b() == Items.field_222070_lD)) {
            return CookingTableRecipeBookCategories.COOKING_TABLE_FOOD;
        }
        return CookingTableRecipeBookCategories.COOKING_TABLE_OTHER;
    }

    public static List<CookingTableRecipeBookCategories> getCategories() {
        return Lists.newArrayList((Object[])new CookingTableRecipeBookCategories[]{CookingTableRecipeBookCategories.COOKING_TABLE_SEARCH, CookingTableRecipeBookCategories.COOKING_TABLE_FOOD});
    }

    public List<RecipeList> getRecipes() {
        return this.allRecipes;
    }

    public List<RecipeList> getRecipes(CookingTableRecipeBookCategories categories) {
        return this.recipesByCategory.getOrDefault((Object)categories, Collections.emptyList());
    }
}

