/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.client.gui;

import com._idrae.cooking_table.CookingTableMod;
import com._idrae.cooking_table.client.gui.CookingTableClientRecipeBook;
import com._idrae.cooking_table.client.gui.CookingTableRecipeBookCategories;
import com._idrae.cooking_table.client.gui.CookingTableRecipeTabToggleWidget;
import com._idrae.cooking_table.containers.CookingTableContainer;
import com._idrae.cooking_table.data.open_state.OpenState;
import com._idrae.cooking_table.network.PlaceNewRecipePacket;
import com._idrae.cooking_table.recipes.CookingTableRecipe;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.recipebook.GhostRecipe;
import net.minecraft.client.gui.recipebook.IRecipeUpdateListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipePlacer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CRecipeInfoPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class CookingTableRecipeBookGui
extends RecipeBookGui
implements IRenderable,
IGuiEventListener,
IRecipeUpdateListener,
IRecipePlacer<Ingredient> {
    protected static final ResourceLocation RECIPE_BOOK = new ResourceLocation("idraes_cooking_table", "textures/gui/cooking_recipe_book.png");
    private int xOffset;
    private int width;
    private int height;
    protected final GhostRecipe field_191915_z = new GhostRecipe();
    private final List<CookingTableRecipeTabToggleWidget> recipeTabs = Lists.newArrayList();
    private CookingTableRecipeTabToggleWidget currentTab;
    protected ToggleWidget field_193960_m;
    protected CookingTableContainer container;
    protected Minecraft field_191888_F;
    private TextFieldWidget searchBar;
    private String lastSearch = "";
    protected CookingTableClientRecipeBook field_193964_s;
    protected final RecipeBookPage field_193022_s = new RecipeBookPage();
    protected final RecipeItemHelper field_193965_u = new RecipeItemHelper();
    private int timesInventoryChanged;
    private boolean keyDown;
    private boolean isFliteringCookable = false;

    public void init(int widthIn, int heightIn, Minecraft minecraftIn, boolean widthTooNarrowIn, CookingTableContainer containerIn) {
        this.field_191888_F = minecraftIn;
        this.width = widthIn;
        this.height = heightIn;
        this.container = containerIn;
        minecraftIn.field_71439_g.field_71070_bA = containerIn;
        this.field_191888_F.field_71439_g.func_199507_B().func_192810_b(false);
        this.field_193964_s = new CookingTableClientRecipeBook(minecraftIn.field_71441_e.func_199532_z());
        this.field_193964_s.rebuildTable();
        this.timesInventoryChanged = minecraftIn.field_71439_g.field_71071_by.func_194015_p();
        this.func_193006_a(OpenState.isOpenState());
        if (this.func_191878_b()) {
            this.func_201518_a(widthTooNarrowIn);
        }
        minecraftIn.field_195559_v.func_197967_a(true);
    }

    public void func_201518_a(boolean widthTooNarrowIn) {
        this.xOffset = widthTooNarrowIn ? 0 : 86;
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.field_193965_u.func_194119_a();
        this.field_191888_F.field_71439_g.field_71071_by.func_201571_a(this.field_193965_u);
        this.container.func_201771_a(this.field_193965_u);
        String s = this.searchBar != null ? this.searchBar.func_146179_b() : "";
        this.searchBar = new TextFieldWidget(this.field_191888_F.field_71466_p, i + 25, j + 14, 80, 14, I18n.func_135052_a((String)"itemGroup.search", (Object[])new Object[0]));
        this.searchBar.func_146203_f(50);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146180_a(s);
        this.field_193022_s.func_194194_a(this.field_191888_F, i, j);
        this.field_193022_s.func_193732_a((RecipeBookGui)this);
        this.field_193960_m = new ToggleWidget(i + 110, j + 12, 26, 16, false);
        this.initBtnTexture();
        this.recipeTabs.clear();
        for (CookingTableRecipeBookCategories category : this.container.getCookingTableRecipeBookCategories()) {
            this.recipeTabs.add(new CookingTableRecipeTabToggleWidget(category, this.field_193964_s));
        }
        if (this.currentTab != null) {
            this.currentTab = this.recipeTabs.stream().filter(tabToggleWidget -> tabToggleWidget.getCategory().equals((Object)this.currentTab.getCategory())).findFirst().orElse(null);
        }
        if (this.currentTab == null) {
            this.currentTab = this.recipeTabs.get(0);
        }
        this.currentTab.func_191753_b(true);
        this.updateCollections(false);
        this.updateTabs();
    }

    public boolean changeFocus(boolean p_changeFocus_1_) {
        return false;
    }

    protected void initBtnTexture() {
        this.field_193960_m.func_191751_a(152, 41, 28, 18, RECIPE_BOOK);
    }

    public void func_191871_c() {
        this.searchBar = null;
        this.currentTab = null;
        this.field_191888_F.field_195559_v.func_197967_a(false);
    }

    public int func_193011_a(boolean p_193011_1_, int p_193011_2_, int p_193011_3_) {
        int i = this.func_191878_b() && !p_193011_1_ ? 177 + (p_193011_2_ - p_193011_3_ - 200) / 2 : (p_193011_2_ - p_193011_3_) / 2;
        return i;
    }

    public void func_191866_a() {
        this.func_193006_a(!this.func_191878_b());
    }

    public boolean func_191878_b() {
        return this.field_193964_s.func_192812_b();
    }

    protected void func_193006_a(boolean visible) {
        this.field_193964_s.func_192813_a(visible);
        OpenState.setOpenState(visible);
        if (!visible) {
            this.field_193022_s.func_194200_c();
        }
        this.func_193956_j();
    }

    public void func_191874_a(@Nullable Slot slotIn) {
        if (slotIn != null && slotIn.field_75222_d < this.container.func_203721_h()) {
            this.field_191915_z.func_192682_a();
            if (this.func_191878_b()) {
                this.updateStackedContents();
            }
        }
    }

    private void updateCollections(boolean p_193003_1_) {
        List<RecipeList> list = this.field_193964_s.getRecipes(this.currentTab.getCategory());
        this.notifyCallerIsCookingTable(list);
        list.forEach(recipeList -> recipeList.func_194210_a(this.field_193965_u, this.container.func_201770_g(), this.container.func_201772_h(), (RecipeBook)this.field_191888_F.field_71439_g.func_199507_B()));
        list.forEach(recipeList -> recipeList.func_194214_a((RecipeBook)this.field_191888_F.field_71439_g.func_199507_B()));
        ArrayList list1 = Lists.newArrayList(list);
        list1.removeIf(recipeList -> !recipeList.func_194209_a());
        list1.removeIf(recipeList -> !recipeList.func_194212_c());
        String s = this.searchBar.func_146179_b();
        if (!s.isEmpty()) {
            ObjectLinkedOpenHashSet objectset = new ObjectLinkedOpenHashSet((Collection)this.field_191888_F.func_213253_a(SearchTreeManager.field_194012_b).func_194038_a(s.toLowerCase(Locale.ROOT)));
            ArrayList<RecipeList> deleteList = new ArrayList<RecipeList>();
            for (RecipeList recipeList2 : list1) {
                boolean flag = false;
                block1: for (IRecipe recipe : recipeList2.func_192711_b()) {
                    for (RecipeList oRecipeList : objectset) {
                        for (IRecipe oRecipe : oRecipeList.func_192711_b()) {
                            if (!recipe.equals(oRecipe)) continue;
                            flag = true;
                            break block1;
                        }
                    }
                }
                if (flag) continue;
                deleteList.add(recipeList2);
            }
            list1.removeAll(deleteList);
        }
        if (this.field_193964_s.func_203432_a(this.container)) {
            list1.removeIf(recipeList -> !recipeList.func_192708_c());
        }
        this.field_193022_s.func_194192_a((List)list1, p_193003_1_);
    }

    private void updateTabs() {
        int i = (this.width - 147) / 2 - this.xOffset - 30;
        int j = (this.height - 166) / 2 + 3;
        int k = 27;
        int l = 0;
        for (CookingTableRecipeTabToggleWidget recipeTabToggleWidget : this.recipeTabs) {
            CookingTableRecipeBookCategories category = recipeTabToggleWidget.getCategory();
            if (category != CookingTableRecipeBookCategories.COOKING_TABLE_SEARCH) {
                if (!recipeTabToggleWidget.checkTabVisible(this.field_193964_s)) continue;
                recipeTabToggleWidget.func_191752_c(i, j + 27 * l++);
                recipeTabToggleWidget.startAnimation(this.field_191888_F);
                continue;
            }
            recipeTabToggleWidget.visible = true;
            recipeTabToggleWidget.func_191752_c(i, j + 27 * l++);
        }
    }

    public void func_193957_d() {
        if (this.func_191878_b() && this.timesInventoryChanged != this.field_191888_F.field_71439_g.field_71071_by.func_194015_p()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.field_191888_F.field_71439_g.field_71071_by.func_194015_p();
        }
    }

    private void updateStackedContents() {
        this.field_193965_u.func_194119_a();
        this.field_191888_F.field_71439_g.field_71071_by.func_201571_a(this.field_193965_u);
        this.container.func_201771_a(this.field_193965_u);
        this.updateCollections(false);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.func_191878_b()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)100.0f);
            this.field_191888_F.func_110434_K().func_110577_a(RECIPE_BOOK);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            this.blit(i, j, 1, 1, 147, 166);
            this.searchBar.render(p_render_1_, p_render_2_, p_render_3_);
            for (CookingTableRecipeTabToggleWidget recipetabtogglewidget : this.recipeTabs) {
                recipetabtogglewidget.render(p_render_1_, p_render_2_, p_render_3_);
            }
            this.field_193960_m.render(p_render_1_, p_render_2_, p_render_3_);
            this.field_193022_s.func_194191_a(i, j, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.popMatrix();
        }
    }

    public void func_191876_c(int p_191876_1_, int p_191876_2_, int p_191876_3_, int p_191876_4_) {
        if (this.func_191878_b()) {
            this.field_193022_s.func_193721_a(p_191876_3_, p_191876_4_);
            if (this.field_193960_m.isHovered()) {
                String s = this.recipeButtonHovered();
                if (this.field_191888_F.field_71462_r != null) {
                    this.field_191888_F.field_71462_r.renderTooltip(s, p_191876_3_, p_191876_4_);
                }
            }
            this.renderGhostRecipeTooltip(p_191876_1_, p_191876_2_, p_191876_3_, p_191876_4_);
        }
    }

    protected String recipeButtonHovered() {
        return I18n.func_135052_a((String)(this.field_193960_m.func_191754_c() ? new TranslationTextComponent("gui.toggle_button.cooking_table", new Object[0]).func_150261_e() : "gui.recipebook.toggleRecipes.all"), (Object[])new Object[0]);
    }

    private void renderGhostRecipeTooltip(int p_193015_1_, int p_193015_2_, int p_193015_3_, int p_193015_4_) {
        ItemStack itemstack = null;
        for (int i = 0; i < this.field_191915_z.func_192684_b(); ++i) {
            GhostRecipe.GhostIngredient ghostrecipe$ghostingredient = this.field_191915_z.func_192681_a(i);
            int j = ghostrecipe$ghostingredient.func_193713_b() + p_193015_1_;
            int k = ghostrecipe$ghostingredient.func_193712_c() + p_193015_2_;
            if (p_193015_3_ < j || p_193015_4_ < k || p_193015_3_ >= j + 16 || p_193015_4_ >= k + 16) continue;
            itemstack = ghostrecipe$ghostingredient.func_194184_c();
        }
        if (itemstack != null && this.field_191888_F.field_71462_r != null) {
            this.field_191888_F.field_71462_r.renderTooltip(this.field_191888_F.field_71462_r.getTooltipFromItem(itemstack), p_193015_3_, p_193015_4_);
        }
    }

    public void func_191864_a(int p_191864_1_, int p_191864_2_, boolean p_191864_3_, float p_191864_4_) {
        this.field_191915_z.func_194188_a(this.field_191888_F, p_191864_1_, p_191864_2_, p_191864_3_, p_191864_4_);
    }

    public boolean mouseClicked(double posX, double posY, int p_mouseClicked_5_) {
        if (this.func_191878_b() && !this.field_191888_F.field_71439_g.func_175149_v()) {
            if (this.field_193022_s.func_198955_a(posX, posY, p_mouseClicked_5_, (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166)) {
                IRecipe irecipe = this.field_193022_s.func_194193_a();
                RecipeList recipelist = this.field_193022_s.func_194199_b();
                if (irecipe != null && recipelist != null) {
                    if (!recipelist.func_194213_a(irecipe) && this.field_191915_z.func_192686_c() == irecipe) {
                        return false;
                    }
                    this.field_191915_z.func_192682_a();
                    CookingTableMod.HANDLER.sendToServer((Object)new PlaceNewRecipePacket(this.field_191888_F.field_71439_g.field_71070_bA.field_75152_c, irecipe, Screen.hasShiftDown()));
                    if (!this.isOffsetNextToMainGUI()) {
                        this.func_193006_a(false);
                    }
                }
                return true;
            }
            if (this.searchBar.mouseClicked(posX, posY, p_mouseClicked_5_)) {
                return true;
            }
            if (this.field_193960_m.mouseClicked(posX, posY, p_mouseClicked_5_)) {
                boolean flag = this.func_201521_f();
                this.field_193960_m.func_191753_b(flag);
                this.func_193956_j();
                this.updateCollections(false);
                return true;
            }
            for (CookingTableRecipeTabToggleWidget recipetabtogglewidget : this.recipeTabs) {
                if (!recipetabtogglewidget.mouseClicked(posX, posY, p_mouseClicked_5_)) continue;
                if (this.currentTab != recipetabtogglewidget) {
                    this.currentTab.func_191753_b(false);
                    this.currentTab = recipetabtogglewidget;
                    this.currentTab.func_191753_b(true);
                    this.updateCollections(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean func_201521_f() {
        boolean flag = !this.isFliteringCookable;
        this.isFliteringCookable = !this.isFliteringCookable;
        this.field_193964_s.func_192810_b(flag);
        return flag;
    }

    public boolean isMouseInsideGUI(double mouseX, double mouseY, int guiLeft, int guiTop, int xSize, int ySize, int mouseButton) {
        if (!this.func_191878_b()) {
            return true;
        }
        boolean flag = mouseX < (double)guiLeft || mouseY < (double)guiTop || mouseX >= (double)(guiLeft + xSize) || mouseY >= (double)(guiTop + ySize);
        boolean flag1 = (double)(guiLeft - 147) < mouseX && mouseX < (double)guiLeft && (double)guiTop < mouseY && mouseY < (double)(guiTop + ySize);
        return flag && !flag1 && !this.currentTab.isHovered();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.keyDown = false;
        if (this.func_191878_b() && !this.field_191888_F.field_71439_g.func_175149_v()) {
            if (p_keyPressed_1_ == 256 && !this.isOffsetNextToMainGUI()) {
                this.func_193006_a(false);
                return true;
            }
            if (this.searchBar.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
                this.updateSearch();
                return true;
            }
            if (this.searchBar.isFocused() && this.searchBar.func_146176_q() && p_keyPressed_1_ != 256) {
                return true;
            }
            if (this.field_191888_F.field_71474_y.field_74310_D.func_197976_a(p_keyPressed_1_, p_keyPressed_2_) && !this.searchBar.isFocused()) {
                this.keyDown = true;
                this.searchBar.func_146195_b(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.keyDown = false;
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.keyDown) {
            return false;
        }
        if (this.func_191878_b() && !this.field_191888_F.field_71439_g.func_175149_v()) {
            if (this.searchBar.charTyped(p_charTyped_1_, p_charTyped_2_)) {
                this.updateSearch();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return false;
    }

    private void updateSearch() {
        String s = this.searchBar.func_146179_b().toLowerCase(Locale.ROOT);
        this.pirateRecipe(s);
        if (!s.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = s;
        }
    }

    private void pirateRecipe(String text) {
        if ("excitedze".equals(text)) {
            LanguageManager languagemanager = this.field_191888_F.func_135016_M();
            Language language = languagemanager.func_191960_a("en_pt");
            if (languagemanager.func_135041_c().compareTo(language) == 0) {
                return;
            }
            languagemanager.func_135045_a(language);
            this.field_191888_F.field_71474_y.field_74363_ab = language.getCode();
            ForgeHooksClient.refreshResources((Minecraft)this.field_191888_F, (VanillaResourceType[])new VanillaResourceType[]{VanillaResourceType.LANGUAGES});
            this.field_191888_F.field_71466_p.func_78275_b(languagemanager.func_135044_b());
            this.field_191888_F.field_71474_y.func_74303_b();
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    public void func_193948_e() {
        this.updateTabs();
        if (this.func_191878_b()) {
            this.updateCollections(false);
        }
    }

    public void func_193001_a(List<IRecipe<?>> recipes) {
        for (IRecipe<?> irecipe : recipes) {
            this.field_191888_F.field_71439_g.func_193103_a(irecipe);
        }
    }

    public void func_193951_a(IRecipe<?> recipe, List<Slot> slotList) {
        ItemStack itemstack = recipe.func_77571_b();
        this.field_191915_z.func_192685_a(recipe);
        this.field_191915_z.func_194187_a(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemstack}), slotList.get((int)0).field_75223_e, slotList.get((int)0).field_75221_f);
        this.func_201501_a(this.container.func_201770_g(), this.container.func_201772_h(), this.container.func_201767_f(), recipe, recipe.func_192400_c().iterator(), 0);
    }

    public void func_201500_a(Iterator<Ingredient> ingredients, int slotIn, int maxAmount, int y, int x) {
        Ingredient ingredient = ingredients.next();
        if (!ingredient.func_203189_d()) {
            Slot slot = (Slot)this.container.field_75151_b.get(slotIn);
            this.field_191915_z.func_194187_a(ingredient, slot.field_75223_e, slot.field_75221_f);
        }
    }

    protected void func_193956_j() {
        if (this.field_191888_F.func_147114_u() != null) {
            this.field_191888_F.func_147114_u().func_147297_a((IPacket)new CRecipeInfoPacket(this.field_193964_s.func_192812_b(), this.field_193964_s.func_192815_c(), this.field_193964_s.func_202883_c(), this.field_193964_s.func_202884_d(), this.field_193964_s.func_216758_e(), this.field_193964_s.func_216761_f()));
        }
    }

    private void notifyCallerIsCookingTable(List<RecipeList> list) {
        block0: for (RecipeList recipeList : list) {
            for (IRecipe recipe : recipeList.func_192711_b()) {
                if (!(recipe instanceof CookingTableRecipe)) continue;
                ((CookingTableRecipe)recipe).isCalledByCookingTable = true;
                continue block0;
            }
        }
    }
}

