/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.client.gui;

import com._idrae.cooking_table.client.gui.CookingTableClientRecipeBook;
import com._idrae.cooking_table.client.gui.CookingTableRecipeBookCategories;
import com._idrae.cooking_table.client.gui.CookingTableRecipeBookGui;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CookingTableRecipeTabToggleWidget
extends ToggleWidget {
    private final CookingTableRecipeBookCategories category;
    private CookingTableClientRecipeBook clientRecipeBook;
    private float animationTime;

    public CookingTableRecipeTabToggleWidget(CookingTableRecipeBookCategories category, CookingTableClientRecipeBook clientRecipeBook) {
        super(0, 0, 35, 27, false);
        this.category = category;
        this.clientRecipeBook = clientRecipeBook;
        this.func_191751_a(153, 2, 35, 0, CookingTableRecipeBookGui.RECIPE_BOOK);
    }

    public void startAnimation(Minecraft mc) {
        List<RecipeList> list = this.clientRecipeBook.getRecipes();
        if (mc.field_71439_g.field_71070_bA instanceof RecipeBookContainer) {
            for (RecipeList recipelist : list) {
                for (IRecipe irecipe : recipelist.func_194208_a(this.clientRecipeBook.func_203432_a((RecipeBookContainer)mc.field_71439_g.field_71070_bA))) {
                    if (!this.clientRecipeBook.func_194076_e(irecipe)) continue;
                    this.animationTime = 15.0f;
                    return;
                }
            }
        }
    }

    public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        if (this.animationTime > 0.0f) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.x + 8), (float)(this.y + 12), (float)0.0f);
            RenderSystem.scalef((float)1.0f, (float)f, (float)1.0f);
            RenderSystem.translatef((float)(-(this.x + 8)), (float)(-(this.y + 12)), (float)0.0f);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.field_191760_o);
        RenderSystem.disableDepthTest();
        int i = this.field_191756_q;
        int j = this.field_191757_r;
        if (this.field_191755_p) {
            i += this.field_191758_s;
        }
        if (this.isHovered()) {
            j += this.field_191759_t;
        }
        int k = this.x;
        if (this.field_191755_p) {
            k -= 2;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(k, this.y, i, j, this.width, this.height);
        RenderSystem.enableDepthTest();
        this.renderIcon(minecraft.func_175599_af());
        if (this.animationTime > 0.0f) {
            RenderSystem.popMatrix();
            this.animationTime -= p_renderButton_3_;
        }
    }

    private void renderIcon(ItemRenderer p_193920_1_) {
        int i;
        List<ItemStack> list = this.category.getIcons();
        int n = i = this.field_191755_p ? -2 : 0;
        if (list.size() == 1) {
            p_193920_1_.func_180450_b(list.get(0), this.x + 9 + i, this.y + 5);
        } else if (list.size() == 2) {
            p_193920_1_.func_180450_b(list.get(0), this.x + 3 + i, this.y + 5);
            p_193920_1_.func_180450_b(list.get(1), this.x + 14 + i, this.y + 5);
        }
    }

    public CookingTableRecipeBookCategories getCategory() {
        return this.category;
    }

    public boolean checkTabVisible(CookingTableClientRecipeBook clientRecipeBook) {
        List<RecipeList> list = clientRecipeBook.getRecipes(this.category);
        this.visible = false;
        if (list != null) {
            for (RecipeList recipelist : list) {
                if (!recipelist.func_194209_a() || !recipelist.func_194212_c()) continue;
                this.visible = true;
                break;
            }
        }
        return this.visible;
    }
}

