/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.containers;

import com._idrae.cooking_table.CookingTableMod;
import com._idrae.cooking_table.containers.CookingTableContainer;
import com._idrae.cooking_table.network.SetupGhostRecipePacket;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.network.PacketDistributor;

public class CookingTableRecipePlacer {
    private CookingTableContainer container;
    private final PlayerEntity player;

    public CookingTableRecipePlacer(CookingTableContainer container) {
        this.container = container;
        this.player = container.getPlayer();
    }

    public void placeNewRecipe(boolean placeAll, IRecipe<?> recipe, ServerPlayerEntity player) {
        if (recipe != null && player.func_192037_E().func_193830_f(recipe) && (this.placeIntoInventory() || player.func_184812_l_())) {
            RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
            recipeItemHelper.func_194119_a();
            player.field_71071_by.func_201571_a(recipeItemHelper);
            this.container.func_201771_a(recipeItemHelper);
            if (recipeItemHelper.func_194116_a(recipe, (IntList)null)) {
                this.tryPlaceRecipe(recipe, placeAll, recipeItemHelper);
            } else {
                this.clear();
                CookingTableMod.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetupGhostRecipePacket(this.container.field_75152_c, recipe));
            }
            player.field_71071_by.func_70296_d();
        }
    }

    protected void tryPlaceRecipe(IRecipe<CraftingInventory> recipe, boolean placeAll, RecipeItemHelper helper) {
        int j1;
        IntArrayList intlist;
        boolean flag = this.container.func_201769_a(recipe);
        int i = helper.func_194114_b(recipe, (IntList)null);
        if (flag) {
            for (int j = 0; j < this.container.func_201772_h() * this.container.func_201770_g() + 1; ++j) {
                ItemStack itemstack;
                if (j == this.container.func_201767_f() || (itemstack = this.container.func_75139_a(j).func_75211_c()).func_190926_b() || Math.min(i, itemstack.func_77976_d()) >= itemstack.func_190916_E() + 1) continue;
                return;
            }
        }
        if (helper.func_194118_a(recipe, (IntList)(intlist = new IntArrayList()), j1 = this.getMaxAmount(placeAll, i, flag))) {
            int k = j1;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int i1 = RecipeItemHelper.func_194115_b((int)l).func_77976_d();
                if (i1 >= k) continue;
                k = i1;
            }
            if (helper.func_194118_a(recipe, (IntList)intlist, k)) {
                this.clear();
                this.placeRecipe(this.container.func_201770_g(), this.container.func_201772_h(), this.container.func_201767_f(), recipe, (Iterator<Integer>)intlist.iterator(), k);
            }
        }
    }

    protected void clear() {
        for (int i = 0; i < this.container.func_201770_g() * this.container.func_201772_h() + 1; ++i) {
            if (i == this.container.func_201767_f()) continue;
            this.giveToPlayer(i);
        }
        this.container.func_201768_e();
    }

    protected void giveToPlayer(int slotIn) {
        ItemStack itemstack = this.container.func_75139_a(slotIn).func_75211_c();
        if (!itemstack.func_190926_b()) {
            while (itemstack.func_190916_E() > 0) {
                int i = this.player.field_71071_by.func_70432_d(itemstack);
                if (i == -1) {
                    i = this.player.field_71071_by.func_70447_i();
                }
                ItemStack itemstack1 = itemstack.func_77946_l();
                itemstack1.func_190920_e(1);
                if (!this.player.field_71071_by.func_191971_c(i, itemstack1)) {
                    CookingTableMod.LOGGER.error("Can't find any space for item in the inventory");
                }
                this.container.func_75139_a(slotIn).func_75209_a(1);
            }
        }
    }

    protected int getMaxAmount(boolean placeAll, int maxPossible, boolean recipeMatches) {
        int i = 1;
        if (placeAll) {
            i = maxPossible;
        } else if (recipeMatches) {
            i = 64;
            for (int j = 0; j < this.container.func_201770_g() * this.container.func_201772_h() + 1; ++j) {
                ItemStack itemstack;
                if (j == this.container.func_201767_f() || (itemstack = this.container.func_75139_a(j).func_75211_c()).func_190926_b() || i <= itemstack.func_190916_E()) continue;
                i = itemstack.func_190916_E();
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    private boolean placeIntoInventory() {
        ArrayList list = Lists.newArrayList();
        int i = this.getNumEmptyPlayerSlots();
        for (int j = 0; j < this.container.func_201770_g() * this.container.func_201772_h() + 1; ++j) {
            ItemStack itemstack;
            if (j == this.container.func_201767_f() || (itemstack = this.container.func_75139_a(j).func_75211_c().func_77946_l()).func_190926_b()) continue;
            int k = this.player.field_71071_by.func_70432_d(itemstack);
            if (k == -1 && list.size() <= i) {
                for (ItemStack itemstack1 : list) {
                    if (!itemstack1.func_77969_a(itemstack) || itemstack1.func_190916_E() == itemstack1.func_77976_d() || itemstack1.func_190916_E() + itemstack.func_190916_E() > itemstack1.func_77976_d()) continue;
                    itemstack1.func_190917_f(itemstack.func_190916_E());
                    itemstack.func_190920_e(0);
                    break;
                }
                if (itemstack.func_190926_b()) continue;
                if (list.size() >= i) {
                    return false;
                }
                list.add(itemstack);
                continue;
            }
            if (k != -1) continue;
            return false;
        }
        return true;
    }

    private int getNumEmptyPlayerSlots() {
        int i = 0;
        for (ItemStack itemstack : this.player.field_71071_by.field_70462_a) {
            if (!itemstack.func_190926_b()) continue;
            ++i;
        }
        return i;
    }

    void placeRecipe(int width, int height, int outputSlot, IRecipe<?> recipe, Iterator<Integer> ingredients, int maxAmount) {
        int i = width;
        int j = height;
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedrecipe = (IShapedRecipe)recipe;
            i = shapedrecipe.getRecipeWidth();
            j = shapedrecipe.getRecipeHeight();
        }
        int k1 = 0;
        block0: for (int k = 0; k < height; ++k) {
            if (k1 == outputSlot) {
                ++k1;
            }
            boolean flag = (float)j < (float)height / 2.0f;
            int l = MathHelper.func_76141_d((float)((float)height / 2.0f - (float)j / 2.0f));
            if (flag && l > k) {
                k1 += width;
                ++k;
            }
            for (int i1 = 0; i1 < width; ++i1) {
                boolean flag1;
                if (!ingredients.hasNext()) {
                    return;
                }
                flag = (float)i < (float)width / 2.0f;
                l = MathHelper.func_76141_d((float)((float)width / 2.0f - (float)i / 2.0f));
                int j1 = i;
                boolean bl = flag1 = i1 < i;
                if (flag) {
                    j1 = l + i;
                    boolean bl2 = flag1 = l <= i1 && i1 < l + i;
                }
                if (flag1) {
                    this.setSlotContents(ingredients, k1, maxAmount, k, i1);
                } else if (j1 == i1) {
                    k1 += width - i1;
                    continue block0;
                }
                ++k1;
            }
        }
    }

    public void setSlotContents(Iterator<Integer> ingredients, int slotIn, int maxAmount, int y, int x) {
        Slot slot = this.container.func_75139_a(slotIn);
        ItemStack itemstack = RecipeItemHelper.func_194115_b((int)ingredients.next());
        if (!itemstack.func_190926_b()) {
            for (int i = 0; i < maxAmount; ++i) {
                this.consumeIngredient(slot, itemstack);
            }
        }
    }

    protected void consumeIngredient(Slot slotToFill, ItemStack ingredientIn) {
        ItemStack itemstack;
        int i = this.player.field_71071_by.func_194014_c(ingredientIn);
        if (i != -1 && !(itemstack = this.player.field_71071_by.func_70301_a(i).func_77946_l()).func_190926_b()) {
            if (itemstack.func_190916_E() > 1) {
                this.player.field_71071_by.func_70298_a(i, 1);
            } else {
                this.player.field_71071_by.func_70304_b(i);
            }
            itemstack.func_190920_e(1);
            if (slotToFill.func_75211_c().func_190926_b()) {
                slotToFill.func_75215_d(itemstack);
            } else {
                slotToFill.func_75211_c().func_190917_f(1);
            }
        }
    }
}

