/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.network;

import com._idrae.cooking_table.containers.CookingTableContainer;
import com._idrae.cooking_table.containers.CookingTableRecipePlacer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaceNewRecipePacket {
    private final int windowId;
    private final ResourceLocation recipeId;
    private final boolean placeAll;

    public PlaceNewRecipePacket(PacketBuffer buffer) {
        this.windowId = buffer.readInt();
        this.recipeId = buffer.func_192575_l();
        this.placeAll = buffer.readBoolean();
    }

    public PlaceNewRecipePacket(int windowId, IRecipe<?> recipe, boolean placeAll) {
        this.windowId = windowId;
        this.recipeId = recipe.func_199560_c();
        this.placeAll = placeAll;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.windowId);
        buffer.func_192572_a(this.recipeId);
        buffer.writeBoolean(this.placeAll);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (!player.func_175149_v() && player.field_71070_bA.field_75152_c == this.getWindowId() && player.field_71070_bA.func_75129_b((PlayerEntity)player) && player.field_71070_bA instanceof CookingTableContainer) {
                player.func_184102_h().func_199529_aN().func_215367_a(this.getRecipeId()).ifPresent(recipe -> {
                    CookingTableRecipePlacer recipePlacer = new CookingTableRecipePlacer((CookingTableContainer)player.field_71070_bA);
                    recipePlacer.placeNewRecipe(this.shouldPlaceAll(), (IRecipe<?>)recipe, player);
                });
            }
        });
        context.get().setPacketHandled(true);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public boolean shouldPlaceAll() {
        return this.placeAll;
    }
}

