/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.network;

import com._idrae.cooking_table.client.gui.CookingTableGhostRecipePlacer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetupGhostRecipePacket {
    private final int windowId;
    private final ResourceLocation recipe;

    public SetupGhostRecipePacket(PacketBuffer buffer) {
        this.windowId = buffer.readInt();
        this.recipe = buffer.func_192575_l();
    }

    public SetupGhostRecipePacket(int windowId, IRecipe<?> recipe) {
        this.windowId = windowId;
        this.recipe = recipe.func_199560_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getRecipeId() {
        return this.recipe;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWindowId() {
        return this.windowId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.windowId);
        buffer.func_192572_a(this.recipe);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::handleOnClient));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleOnClient() {
        CookingTableGhostRecipePlacer.handlePlaceGhostRecipe(Minecraft.func_71410_x(), this.getWindowId(), this.getRecipeId());
    }
}

