/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.cooking_table.recipes;

import com._idrae.cooking_table.util.RegistryHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CookingTableRecipe
extends ShapedRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    public static final IRecipeType<CookingTableRecipe> COOKING = IRecipeType.func_222147_a((String)"cooking");
    protected final int field_77576_b;
    protected final int field_77577_c;
    protected final NonNullList<Ingredient> field_77574_d;
    protected final ItemStack field_77575_e;
    private final ResourceLocation id;
    protected final String field_194137_e;
    public boolean isCalledByCookingTable = false;

    public CookingTableRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.id = idIn;
        this.field_194137_e = groupIn;
        this.field_77576_b = recipeWidthIn;
        this.field_77577_c = recipeHeightIn;
        this.field_77574_d = recipeItemsIn;
        this.field_77575_e = recipeOutputIn;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)RegistryHandler.COOKING_TABLE_BLOCK.get());
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RegistryHandler.COOKING_RECIPES_SERIALIZER.get();
    }

    protected static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, CookingTableRecipe.firstNonSpace(s));
            int j1 = CookingTableRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    protected static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    protected static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return COOKING;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.field_77576_b; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.field_77577_c; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.field_77576_b && l < this.field_77577_c) {
                    ingredient = p_77573_4_ ? (Ingredient)this.field_77574_d.get(this.field_77576_b - k - 1 + l * this.field_77576_b) : (Ingredient)this.field_77574_d.get(k + l * this.field_77576_b);
                }
                if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        if (this.isCalledByCookingTable) {
            this.isCalledByCookingTable = false;
            return width >= this.field_77576_b && height >= this.field_77577_c;
        }
        return false;
    }

    public ItemStack func_77571_b() {
        return this.field_77575_e;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

