/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import ovh.corail.recycler.tileentity.TileEntityRecycler;
import ovh.corail.recycler.util.Helper;

public class BlockRecycler
extends Block {
    private static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");

    public BlockRecycler() {
        super(BlockRecycler.getBuilder());
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        return "corail_recycler.block.recycler";
    }

    public ToolType getHarvestTool(IBlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Helper.isValidPlayer(player) && !player.func_175149_v()) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)BlockRecycler.getTileEntity(world, pos), buf -> buf.func_179255_a(pos));
            }
            return true;
        }
        return false;
    }

    public void func_196243_a(IBlockState oldState, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            TileEntityRecycler recycler = BlockRecycler.getTileEntity(world, pos);
            if (recycler != null) {
                for (ItemStack stack : recycler.getInventoryInput()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
                for (ItemStack stack : recycler.getInventoryWorking()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
                for (ItemStack stack : recycler.getInventoryOutput()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
                world.func_175713_t(pos);
            }
            super.func_196243_a(oldState, world, pos, newState, isMoving);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, @Nullable EntityLivingBase entity, ItemStack stack) {
        if (entity != null) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()));
        }
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 15 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ENABLED});
    }

    @Nullable
    public static TileEntityRecycler getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityRecycler ? (TileEntityRecycler)tile : null;
    }

    public TileEntityRecycler createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityRecycler();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected static Block.Properties getBuilder() {
        return Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 20.0f).func_200947_a(SoundType.field_185851_d);
    }
}

