/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemInput;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.util.JsonRecyclingRecipe;
import ovh.corail.recycler.util.RecyclingManager;
import ovh.corail.recycler.util.TranslationHelper;

public class CommandRecycler {
    private final CommandDispatcher<CommandSource> commandDispatcher;

    public CommandRecycler(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    public void registerCommands() {
        this.commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"recycler").requires(p -> p.func_197034_c(3))).executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add_recipe").executes(c -> this.processAddRecipe((CommandSource)c.getSource(), null))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> this.processAddRecipe((CommandSource)c.getSource(), ItemArgument.func_197316_a((CommandContext)c, (String)"item")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove_recipe").executes(c -> this.processRemoveRecipe((CommandSource)c.getSource(), null))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> this.processRemoveRecipe((CommandSource)c.getSource(), ItemArgument.func_197316_a((CommandContext)c, (String)"item")))))).then(Commands.func_197057_a((String)"export_crafting_recipes").executes(c -> this.processExportCraftingRecipes((CommandSource)c.getSource()))));
    }

    private int processAddRecipe(CommandSource source, ItemInput stack) {
        try {
            EntityPlayerMP player = source.func_197035_h();
            RecyclingManager.instance.discoverRecipe(player, stack == null ? player.func_184614_ca() : stack.func_197320_a(1, false));
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int processRemoveRecipe(CommandSource source, ItemInput stack) {
        try {
            EntityPlayerMP player = source.func_197035_h();
            boolean success = RecyclingManager.instance.removeRecipe(stack == null ? player.func_184614_ca() : stack.func_197320_a(1, false));
            TranslationHelper.sendMessage(player, success ? TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_FAILED, new Object[0]);
            return success ? 1 : 0;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int processExportCraftingRecipes(CommandSource source) {
        try {
            EntityPlayerMP player = source.func_197035_h();
            RecyclingManager rm = RecyclingManager.instance;
            ArrayList<JsonRecyclingRecipe> list = new ArrayList<JsonRecyclingRecipe>();
            for (IRecipe crafting_recipe : player.field_70170_p.func_199532_z().func_199510_b()) {
                JsonRecyclingRecipe res;
                if (crafting_recipe.func_77571_b().func_190926_b() || rm.hasRecipe(crafting_recipe.func_77571_b()) != -1 || (res = rm.convertRecipeToJson(rm.convertCraftingRecipe(crafting_recipe))) == null) continue;
                list.add(res);
            }
            File exportFile = new File(ModRecycler.configDir, "export_crafting_recipes.json");
            TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_FOUND_RECIPES, list.size());
            boolean success = rm.saveAsJson(exportFile, list);
            TranslationHelper.sendMessage(player, success ? TranslationHelper.LangKey.MESSAGE_EXPORT_SUCCESS : TranslationHelper.LangKey.MESSAGE_EXPORT_FAILED, new Object[0]);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int showUsage(CommandSource source) {
        source.func_197030_a((ITextComponent)new TextComponentString("recycler <command>"), false);
        source.func_197030_a((ITextComponent)new TextComponentString("add_recipe : add the recycling recipe of the crafting result of the item hold in main hand"), false);
        source.func_197030_a((ITextComponent)new TextComponentString("remove_recipe : remove the recycling recipe of the item hold in main hand"), false);
        source.func_197030_a((ITextComponent)new TextComponentString("export_crafting_recipes : save the list of all crafting recipes in \"recycling\" format in the config directory"), false);
        return 1;
    }
}

