/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;
import ovh.corail.recycler.registry.ModAdvancements;
import ovh.corail.recycler.tileentity.TileEntityRecycler;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.RecyclingManager;
import ovh.corail.recycler.util.TranslationHelper;

public class ServerRecyclerMessage {
    private final MessageAction action;
    private final BlockPos pos;
    private boolean isWorking;
    private int pageNum;
    private String searchText;

    public ServerRecyclerMessage(MessageAction action, BlockPos pos, Object ... params) {
        this.action = action;
        this.pos = pos;
        if (action == MessageAction.SWITCH_AUTO) {
            this.isWorking = params.length == 1 && (Boolean)params[0] != false;
        } else if (action == MessageAction.CHANGE_PAGE) {
            this.pageNum = params.length == 1 ? (Integer)params[0] : 0;
        } else if (action == MessageAction.SEARCH_TEXT) {
            this.searchText = params.length == 1 ? String.valueOf(params[0]) : "";
        }
    }

    public static ServerRecyclerMessage fromBytes(PacketBuffer buf) {
        MessageAction currentAction = MessageAction.values()[buf.readShort()];
        BlockPos currentPos = BlockPos.func_177969_a((long)buf.readLong());
        switch (currentAction) {
            case SWITCH_AUTO: {
                return new ServerRecyclerMessage(currentAction, currentPos, buf.readBoolean());
            }
            case CHANGE_PAGE: {
                return new ServerRecyclerMessage(currentAction, currentPos, buf.readInt());
            }
            case SEARCH_TEXT: {
                return new ServerRecyclerMessage(currentAction, currentPos, buf.func_150789_c(20));
            }
        }
        return new ServerRecyclerMessage(currentAction, currentPos, new Object[0]);
    }

    public static void toBytes(ServerRecyclerMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        buf.writeLong(msg.pos.func_177986_g());
        if (msg.action == MessageAction.SWITCH_AUTO) {
            buf.writeBoolean(msg.isWorking);
        } else if (msg.action == MessageAction.CHANGE_PAGE) {
            buf.writeInt(msg.pageNum);
        } else if (msg.action == MessageAction.SEARCH_TEXT) {
            buf.func_180714_a(msg.searchText);
        }
    }

    public static class Handler {
        public static void handle(ServerRecyclerMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                TileEntityRecycler recycler;
                EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (recycler = BlockRecycler.getTileEntity(player.field_70170_p, message.pos)) != null) {
                    switch (message.action) {
                        case RECYCLE: {
                            if (!recycler.recycle(player)) break;
                            Helper.grantAdvancement((EntityPlayer)player, ModAdvancements.FIRST_RECYCLE);
                            break;
                        }
                        case SWITCH_AUTO: {
                            recycler.updateWorking(message.isWorking);
                            break;
                        }
                        case TAKE_ALL: {
                            RecyclerDefaultStackHandler inventOutput = recycler.getInventoryOutput();
                            for (int slot = 0; slot < inventOutput.getSlots(); ++slot) {
                                if (inventOutput.getStackInSlot(slot).func_190926_b()) continue;
                                inventOutput.setStackInSlot(slot, Helper.addToInventoryWithLeftover(inventOutput.getStackInSlot(slot), (IInventory)player.field_71071_by, false));
                            }
                            break;
                        }
                        case DISCOVER_RECIPE: {
                            try {
                                RecyclingManager.instance.discoverRecipe(player, recycler.getInventoryWorking().getStackInSlot(0));
                                recycler.updateRecyclingRecipe();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case REMOVE_RECIPE: {
                            boolean success = RecyclingManager.instance.removeRecipe(recycler.getInventoryWorking().getStackInSlot(0));
                            TranslationHelper.sendMessage(player, success ? TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_FAILED, new Object[0]);
                            recycler.updateRecyclingRecipe();
                            break;
                        }
                        case RECYCLING_BOOK: {
                            break;
                        }
                        case CHANGE_PAGE: {
                            recycler.updateRecyclingBook(message.pageNum);
                            break;
                        }
                        case SEARCH_TEXT: {
                            recycler.updateRecyclingBook(message.searchText);
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum MessageAction {
        RECYCLE,
        SWITCH_AUTO,
        TAKE_ALL,
        DISCOVER_RECIPE,
        REMOVE_RECIPE,
        RECYCLING_BOOK,
        CHANGE_PAGE,
        SEARCH_TEXT;

    }
}

