/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.registry;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.block.ItemBlockRecycler;
import ovh.corail.recycler.item.ItemDiamondDisk;
import ovh.corail.recycler.item.ItemGeneric;
import ovh.corail.recycler.registry.ModBlocks;

@Mod.EventBusSubscriber(modid="corail_recycler", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryHandler.registerForgeEntry(event.getRegistry(), new BlockRecycler(), "recycler");
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerItems(RegistryEvent.Register<Item> event) {
        RegistryHandler.registerForgeEntry(event.getRegistry(), new ItemGeneric("diamond_shard"), "diamond_shard");
        RegistryHandler.registerForgeEntry(event.getRegistry(), new ItemDiamondDisk(), "diamond_disk");
        RegistryHandler.registerForgeEntry(event.getRegistry(), new ItemBlockRecycler(ModBlocks.recycler), ModBlocks.recycler.getRegistryName());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        RegistryHandler.registerForgeEntry((IForgeRegistry<SoundEvent>)event.getRegistry(), "recycler");
        RegistryHandler.registerForgeEntry((IForgeRegistry<SoundEvent>)event.getRegistry(), "recycler_working");
    }

    private static void registerForgeEntry(IForgeRegistry<SoundEvent> registry, String name) {
        ResourceLocation rl = new ResourceLocation("corail_recycler", name);
        registry.register(new SoundEvent(rl).setRegistryName(rl));
    }

    private static <T extends IForgeRegistryEntry<T>> void registerForgeEntry(IForgeRegistry<T> registry, T entry, String name) {
        registry.register((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation("corail_recycler", name)));
    }

    private static <T extends IForgeRegistryEntry<T>> void registerForgeEntry(IForgeRegistry<T> registry, T entry, @Nullable ResourceLocation locName) {
        if (locName != null) {
            registry.register((IForgeRegistryEntry)entry.setRegistryName(locName));
        } else {
            Biome.field_150586_aC.warn("can't register a forge entry with a null resourceLocation : " + entry.getClass().getName() + "[" + entry.getRegistryType().getName() + "]");
        }
    }
}

