/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Particles;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.INameable;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.recycler.ConfigRecycler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.capability.EnergyStorageMutable;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;
import ovh.corail.recycler.capability.RecyclerWorkingStackHandler;
import ovh.corail.recycler.gui.ContainerRecycler;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.registry.ModSounds;
import ovh.corail.recycler.registry.ModTileEntityTypes;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.RecyclingManager;
import ovh.corail.recycler.util.RecyclingRecipe;
import ovh.corail.recycler.util.TranslationHelper;

public class TileEntityRecycler
extends TileEntity
implements ITickable,
INameable,
IInteractionObject {
    private String customName;
    private final RecyclerDefaultStackHandler inventInput = new RecyclerDefaultStackHandler(18);
    private final RecyclerWorkingStackHandler inventWorking = new RecyclerWorkingStackHandler();
    private final RecyclerDefaultStackHandler inventOutput = new RecyclerDefaultStackHandler(18);
    private final RecyclerDefaultStackHandler inventVisual = new RecyclerDefaultStackHandler(9);
    private final RecyclerDefaultStackHandler inventRecyclingBook = new RecyclerDefaultStackHandler(40);
    private final EnergyStorageMutable energyStorage = new EnergyStorageMutable();
    private final int maxTicks;
    private int countTicks;
    private boolean isWorking;
    private int progress;
    private int inputMax;
    private int cantRecycleTicks;
    private int pageNum;
    private int pageMax;
    private String searchText;
    private boolean isProcessing;

    public TileEntityRecycler() {
        super(ModTileEntityTypes.RECYCLER);
        this.maxTicks = (Integer)ConfigRecycler.general.time_to_recycle.get();
        this.countTicks = 0;
        this.isWorking = false;
        this.progress = 0;
        this.inputMax = 0;
        this.cantRecycleTicks = 0;
        this.pageNum = 0;
        this.pageMax = 0;
        this.searchText = "";
    }

    public RecyclerDefaultStackHandler getInventoryInput() {
        return this.inventInput;
    }

    public RecyclerWorkingStackHandler getInventoryWorking() {
        return this.inventWorking;
    }

    public RecyclerDefaultStackHandler getInventoryOutput() {
        return this.inventOutput;
    }

    public RecyclerDefaultStackHandler getInventoryVisual() {
        return this.inventVisual;
    }

    public RecyclerDefaultStackHandler getInventoryRecyclingBook() {
        return this.inventRecyclingBook;
    }

    public int getRecyclingBookPageNum() {
        return this.pageNum;
    }

    public void setRecyclingBookPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getRecyclingBookPageMax() {
        return this.pageMax;
    }

    public void setRecyclingBookPageMax(int pageMax) {
        this.pageMax = pageMax;
    }

    public void initRecyclingBook() {
        this.searchText = "";
        this.pageNum = 0;
        this.updateRecyclingBookSlots(RecyclingManager.instance.getPage(this.pageNum, this.searchText));
        this.pageMax = RecyclingManager.instance.getPageCount(this.searchText) / 4;
    }

    public void updateRecyclingBook(int pageNum) {
        this.updateRecyclingBookSlots(RecyclingManager.instance.getPage(pageNum, this.searchText));
        this.pageNum = pageNum;
    }

    public void updateRecyclingBook(String searchText) {
        this.updateRecyclingBookSlots(RecyclingManager.instance.getPage(0, searchText));
        this.searchText = searchText;
        this.pageNum = 0;
        this.pageMax = RecyclingManager.instance.getPageCount(searchText) / 4;
    }

    private void updateRecyclingBookSlots(List<RecyclingRecipe> recipes) {
        int slotId = 0;
        for (RecyclingRecipe recipe : recipes) {
            this.inventRecyclingBook.setStackInSlot(slotId++, recipe.getItemRecipe());
            for (int i = 0; i < 9; ++i) {
                this.inventRecyclingBook.setStackInSlot(slotId++, i < recipe.getCount() ? recipe.getStack(i) : ItemStack.field_190927_a);
            }
        }
        while (slotId < 40) {
            this.inventRecyclingBook.setStackInSlot(slotId++, ItemStack.field_190927_a);
        }
    }

    public boolean isOutputEmpty() {
        return this.inventOutput.stream().noneMatch(p -> p != ItemStack.field_190927_a);
    }

    public int getEmptySlotInOutPut() {
        for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
            if (!this.inventOutput.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    private void transferSlotWorking() {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)this.inventWorking.extractItem(0, this.inventWorking.getStackInSlot(0).func_190916_E(), false), (boolean)false);
    }

    public boolean hasSpaceInInventory(List<ItemStack> itemsList, boolean simulate) {
        int emptySlot;
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
            if (!this.inventOutput.getStackInSlot(slot).func_190926_b()) continue;
            emptySlots.add(slot);
        }
        List<ItemStack> resultList = this.inventOutput.getInventoryList();
        if (simulate && emptySlots.size() >= itemsList.size()) {
            return true;
        }
        int minCount = simulate ? itemsList.size() - emptySlots.size() : 0;
        for (int i = 0; i < itemsList.size(); ++i) {
            ItemStack stackIn = itemsList.get(i);
            if (stackIn.func_190926_b()) {
                if (!simulate) continue;
                --minCount;
                continue;
            }
            if (stackIn.func_190916_E() == stackIn.func_77976_d()) continue;
            int left = stackIn.func_190916_E();
            int maxSize = stackIn.func_77976_d();
            for (ItemStack aResultList : resultList) {
                int space;
                int add;
                ItemStack stackOut = aResultList;
                if (stackOut.func_190926_b() || stackOut.func_190916_E() == stackOut.func_77976_d() || !Helper.areItemEqual(stackIn, stackOut) || (add = Math.min(space = maxSize - stackOut.func_190916_E(), left)) <= 0) continue;
                stackOut.func_190917_f(add);
                if ((left -= add) > 0) continue;
                break;
            }
            if (left <= 0 && simulate) {
                --minCount;
            }
            if (left > 0) {
                if (emptySlots.size() > 0) {
                    emptySlot = (Integer)emptySlots.get(0);
                    emptySlots.remove(0);
                    ItemStack stackCopy = stackIn.func_77946_l();
                    stackCopy.func_190920_e(left);
                    resultList.set(emptySlot, stackCopy);
                    if (simulate) {
                        ++minCount;
                    }
                } else {
                    return false;
                }
            }
            if (simulate && minCount <= 0) {
                return true;
            }
            itemsList.set(i, ItemStack.field_190927_a);
        }
        for (ItemStack stack : itemsList) {
            if (stack.func_190926_b() || emptySlots.size() <= 0) continue;
            emptySlot = (Integer)emptySlots.get(0);
            emptySlots.remove(0);
            resultList.set(emptySlot, stack.func_77946_l());
        }
        if (!simulate) {
            for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
                this.inventOutput.setStackInSlot(slot, resultList.get(slot));
            }
        }
        return true;
    }

    public boolean recycle(@Nullable EntityPlayerMP player) {
        List<ItemStack> itemsList;
        int maxDiskUse;
        RecyclingManager recyclingManager = RecyclingManager.instance;
        ItemStack workingStack = this.inventWorking.getStackInSlot(0);
        ItemStack diskStack = this.inventWorking.getStackInSlot(1);
        if (workingStack.func_190926_b() || diskStack.func_190926_b()) {
            return false;
        }
        RecyclingRecipe recipe = recyclingManager.getRecipe(workingStack);
        if (recipe == null) {
            this.transferSlotWorking();
            return false;
        }
        int nb_input = workingStack.func_190916_E() / recipe.getItemRecipe().func_190916_E();
        if (nb_input == 0) {
            return false;
        }
        if (this.isWorking) {
            nb_input = 1;
        }
        if ((maxDiskUse = (diskStack.func_77958_k() - diskStack.func_77952_i()) / 10) < nb_input) {
            nb_input = maxDiskUse;
        }
        if (!this.hasSpaceInInventory(itemsList = recyclingManager.getResultStack(workingStack, nb_input), true)) {
            TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS, new Object[0]);
            return false;
        }
        int loss = 0;
        if ((Integer)ConfigRecycler.general.chance_loss.get() > 0) {
            for (int i = 0; i < nb_input; ++i) {
                if (Helper.getRandom(1, 100) > (Integer)ConfigRecycler.general.chance_loss.get()) continue;
                ++loss;
            }
            if (loss > 0) {
                TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_LOSS, new Object[0]);
            }
        }
        List<Object> stackList = nb_input - loss > 0 ? recyclingManager.getResultStack(workingStack, nb_input - loss) : new ArrayList();
        if (loss > 0) {
            List<ItemStack> halfstackList = recyclingManager.getResultStack(workingStack, loss, true);
            stackList.addAll(halfstackList);
        }
        this.hasSpaceInInventory(stackList, false);
        this.inventWorking.getStackInSlot(0).func_190918_g(nb_input * recipe.getItemRecipe().func_190916_E());
        int diskDamage = 10 * nb_input;
        if (diskStack.func_77952_i() + diskDamage >= diskStack.func_77958_k()) {
            TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_BROKEN_DISK, new Object[0]);
            this.inventWorking.setStackInSlot(1, ItemStack.field_190927_a);
        } else {
            this.inventWorking.getStackInSlot(1).func_196085_b(diskStack.func_77952_i() + diskDamage);
        }
        ModSounds.playSoundAllAround(ModSounds.RECYCLER, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
        return true;
    }

    public boolean isProcessingRecipe() {
        return this.isProcessing;
    }

    public void setProcessingRecipe(boolean state) {
        this.isProcessing = state;
    }

    public void func_73660_a() {
        RecyclingRecipe baseRecipe;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            int slotId2;
            if (this.inventWorking.getStackInSlot(0).func_190926_b()) {
                for (slotId2 = 0; slotId2 < this.inventInput.getSlots(); ++slotId2) {
                    if (this.inventInput.getStackInSlot(slotId2).func_190926_b() || this.inventInput.getStackInSlot(slotId2).func_77973_b() == ModItems.diamond_disk) continue;
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId2, this.inventInput.getStackInSlot(slotId2).func_190916_E(), false), false);
                    this.updateRecyclingRecipe();
                    break;
                }
            } else if (this.inventWorking.getStackInSlot(0).func_77985_e() && this.inventWorking.getStackInSlot(0).func_190916_E() < this.inventWorking.getStackInSlot(0).func_77976_d()) {
                for (slotId2 = 0; slotId2 < this.inventInput.getSlots(); ++slotId2) {
                    if (!Helper.areItemEqual(this.inventWorking.getStackInSlot(0), this.inventInput.getStackInSlot(slotId2))) continue;
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId2, 1, false), false);
                    this.updateRecyclingRecipe();
                    break;
                }
            }
            if (this.inventWorking.getStackInSlot(1).func_190926_b()) {
                IntStream.range(0, this.inventInput.getSlots()).filter(slotId -> this.inventInput.getStackInSlot(slotId).func_77973_b() == ModItems.diamond_disk).findFirst().ifPresent(slotId -> this.inventWorking.insertItem(1, this.inventInput.extractItem(slotId, 1, false), false));
            }
        }
        int n = this.inputMax = (baseRecipe = RecyclingManager.instance.getRecipe(this.inventWorking.getStackInSlot(0))) != null ? this.inventWorking.getStackInSlot(0).func_190916_E() / baseRecipe.getItemRecipe().func_190916_E() : 0;
        if (this.inputMax > 0) {
            this.inputMax = Math.min(this.inputMax, (this.inventWorking.getStackInSlot(1).func_77958_k() - this.inventWorking.getStackInSlot(1).func_77952_i()) / 10);
        }
        this.setProcessingRecipe(this.inputMax > 0);
        if (!this.isWorking) {
            return;
        }
        if (!((Boolean)ConfigRecycler.general.allow_automation.get()).booleanValue()) {
            this.updateWorking(false);
            return;
        }
        if (this.energyStorage.getEnergyStored() >= 10) {
            this.energyStorage.extractEnergy(10, false);
            this.countTicks -= 2;
        } else {
            --this.countTicks;
        }
        if (!this.isProcessingRecipe()) {
            ++this.cantRecycleTicks;
            this.countTicks = this.maxTicks;
        }
        if (this.cantRecycleTicks > 40) {
            if (!this.inventWorking.getStackInSlot(0).func_190926_b()) {
                this.transferSlotWorking();
            }
            this.updateWorking(false);
            this.cantRecycleTicks = 0;
            this.countTicks = this.maxTicks;
        }
        if (this.countTicks <= 0) {
            if (!this.recycle(null)) {
                ++this.cantRecycleTicks;
            }
            this.countTicks = this.maxTicks;
        } else if (this.cantRecycleTicks <= 1 && this.countTicks % 15 == 0) {
            ModSounds.playSoundAllAround(ModSounds.RECYCLER_WORKING, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
            for (int i = 0; i < 4; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)Particles.field_197601_L, (double)this.field_174879_c.func_177958_n() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177956_o() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177952_p() + Helper.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        this.progress = (this.maxTicks - this.countTicks) * 100 / this.maxTicks;
    }

    public void updateRecyclingRecipe() {
        int slotId;
        boolean hasRecipe = RecyclingManager.instance.hasRecipe(this.getInventoryWorking().getStackInSlot(0)) >= 0;
        ArrayList currentRecipe = hasRecipe ? RecyclingManager.instance.getResultStack(this.getInventoryWorking().getStackInSlot(0), 1) : new ArrayList();
        if (hasRecipe) {
            for (slotId = 0; slotId < Math.min(currentRecipe.size(), this.inventVisual.getSlots()); ++slotId) {
                if (Helper.areItemEqual((ItemStack)currentRecipe.get(slotId), this.inventVisual.getStackInSlot(slotId))) continue;
                this.inventVisual.setStackInSlot(slotId, (ItemStack)currentRecipe.get(slotId));
            }
        }
        while (slotId < this.inventVisual.getSlots()) {
            if (!this.inventVisual.getStackInSlot(slotId).func_190926_b()) {
                this.inventVisual.setStackInSlot(slotId, ItemStack.field_190927_a);
            }
            ++slotId;
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void updateWorking(boolean isWorking) {
        this.setProgress(0);
        if (isWorking != this.isWorking) {
            this.isWorking = isWorking;
            this.field_145850_b.func_175656_a(this.field_174879_c, (IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(isWorking)));
        }
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.countTicks = this.maxTicks;
        }
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setInputMax(int inputMax) {
        this.inputMax = inputMax;
    }

    public int getInputMax() {
        return this.inputMax;
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("corail_recyclerblock.recycler.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.customName, new Object[0]) : this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.customName, new Object[0]) : null;
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergyStored(energy);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == EnumFacing.DOWN) {
                return LazyOptional.of(() -> this.inventOutput);
            }
            return LazyOptional.of(() -> this.inventInput);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage);
        }
        return super.getCapability(cap, side);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("invent_input", (INBTBase)this.inventInput.serializeNBT());
        compound.func_74782_a("invent_working", (INBTBase)this.inventWorking.serializeNBT());
        compound.func_74782_a("invent_output", (INBTBase)this.inventOutput.serializeNBT());
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        compound.func_74768_a("countTicks", this.countTicks);
        compound.func_74757_a("isWorking", this.isWorking);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("cantRecycleTicks", this.cantRecycleTicks);
        INBTBase nbt = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (nbt != null) {
            compound.func_74782_a("energy", nbt);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventInput.deserializeNBT(compound.func_74775_l("invent_input"));
        this.inventWorking.deserializeNBT(compound.func_74775_l("invent_working"));
        this.inventOutput.deserializeNBT(compound.func_74775_l("invent_output"));
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.countTicks = compound.func_74762_e("countTicks");
        this.isWorking = compound.func_74767_n("isWorking");
        this.progress = compound.func_74762_e("progress");
        this.cantRecycleTicks = compound.func_74762_e("cantRecycleTicks");
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, compound.func_74781_a("energy"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerRecycler(player, this);
    }

    public String func_174875_k() {
        return "corail_recycler:recycler";
    }
}

