/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import ovh.corail.recycler.registry.ModAdvancements;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Helper {
    public static final Random random = new Random();

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static boolean isValidPlayer(@Nullable EntityPlayer player) {
        return player != null && Helper.isNotFakePlayer((EntityLivingBase)player);
    }

    public static boolean isValidPlayerMP(@Nullable EntityPlayer player) {
        return player != null && !player.field_70170_p.field_72995_K && Helper.isNotFakePlayer((EntityLivingBase)player);
    }

    private static boolean isNotFakePlayer(EntityLivingBase entity) {
        return !(entity instanceof FakePlayer);
    }

    public static void grantAdvancement(@Nullable EntityPlayer playerIn, ModAdvancements modAdvancement) {
        if (!Helper.isValidPlayerMP(playerIn)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerIn;
        AdvancementManager am = player.field_71133_b.func_191949_aK();
        Advancement advancement = am.func_192778_a(modAdvancement.getRL());
        if (advancement == null) {
            return;
        }
        AdvancementProgress advancementprogress = player.func_192039_O().func_192747_a(advancement);
        if (!advancementprogress.func_192105_a()) {
            for (String criteria : advancementprogress.func_192107_d()) {
                player.func_192039_O().func_192750_a(advancement, criteria);
            }
        }
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return !s1.func_190926_b() && s1.func_77973_b() == s2.func_77973_b();
    }

    public static List<ItemStack> mergeStackInList(List<ItemStack> itemStackList) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        for (ItemStack stack : itemStackList) {
            ItemStack currentStack = stack.func_77946_l();
            for (ItemStack lookStack : outputList) {
                int add;
                if (currentStack.func_190926_b() || !currentStack.func_77985_e()) break;
                if (!Helper.areItemEqual(currentStack, lookStack) || lookStack.func_190926_b() || lookStack.func_190916_E() == lookStack.func_77976_d() || (add = Math.min(currentStack.func_190916_E(), lookStack.func_77976_d() - lookStack.func_190916_E())) <= 0) continue;
                currentStack.func_190918_g(add);
                lookStack.func_190917_f(add);
            }
            if (currentStack.func_190926_b()) continue;
            outputList.add(currentStack);
        }
        return outputList;
    }

    public static ItemStack addToInventoryWithLeftover(ItemStack stack, IInventory inventory, boolean simulate) {
        ItemStack in;
        int i;
        int left = stack.func_190916_E();
        int minus = inventory instanceof InventoryPlayer ? 4 : 0;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            int space;
            int add;
            in = inventory.func_70301_a(i);
            if (in.func_190926_b() || !Helper.areItemEqual(in, stack) || (add = Math.min(space = max - in.func_190916_E(), stack.func_190916_E())) <= 0) continue;
            if (!simulate) {
                in.func_190917_f(add);
            }
            if ((left -= add) > 0) continue;
            return ItemStack.field_190927_a;
        }
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            in = inventory.func_70301_a(i);
            if (!in.func_190926_b()) continue;
            int add = Math.min(max, left);
            if (!simulate) {
                inventory.func_70299_a(i, Helper.copyStack(stack, add));
            }
            if ((left -= add) > 0) continue;
            return ItemStack.field_190927_a;
        }
        return Helper.copyStack(stack, left);
    }

    private static ItemStack copyStack(ItemStack stack, int size) {
        if (stack.func_190926_b() || size == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack tmp = stack.func_77946_l();
        tmp.func_190920_e(Math.min(size, stack.func_77976_d()));
        return tmp;
    }
}

