/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import ovh.corail.recycler.ConfigRecycler;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.registry.ModBlocks;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.JsonRecyclingRecipe;
import ovh.corail.recycler.util.RecyclingRecipe;
import ovh.corail.recycler.util.TranslationHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecyclingManager {
    public static final RecyclingManager instance = new RecyclingManager();
    private final List<RecyclingRecipe> recipes = new ArrayList<RecyclingRecipe>();
    private final Set<ItemStack> unbalanced = new HashSet<ItemStack>();
    private final Set<ItemStack> blacklist = new HashSet<ItemStack>();
    private final List<ImmutablePair<ItemStack, ItemStack>> grindList = new ArrayList<ImmutablePair<ItemStack, ItemStack>>();
    private final File unbalancedFile = new File(ModRecycler.configDir, "unbalanced_recipes.json");
    private final File blacklistFile = new File(ModRecycler.configDir, "blacklist_recipes.json");
    private final File userDefinedFile = new File(ModRecycler.configDir, "user_defined_recipes.json");
    private final File grindFile = new File(ModRecycler.configDir, "grind_list.json");

    private RecyclingManager() {
    }

    public void discoverRecipe(EntityPlayerMP player, ItemStack stack) {
        int hasRecipe = this.getRecipeIndex(stack);
        if (hasRecipe >= 0) {
            if (this.getRecipe(hasRecipe).isAllowed()) {
                TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            } else {
                this.getRecipe(hasRecipe).setAllowed(true);
                this.saveBlacklist();
                TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_SUCCESS, new Object[0]);
            }
        } else {
            boolean valid = false;
            RecyclingRecipe recipe = null;
            for (IRecipe crafting_recipe : player.field_70170_p.func_199532_z().func_199510_b()) {
                ItemStack o = crafting_recipe.func_77571_b();
                if (!Helper.areItemEqual(o, stack) || (recipe = this.convertCraftingRecipe(crafting_recipe)).getCount() <= 0 || recipe.getItemRecipe().func_190926_b()) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.addRecipe(recipe);
                TranslationHelper.sendMessage(player, this.saveUserDefinedRecipes() ? TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            } else {
                TranslationHelper.sendMessage(player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            }
        }
    }

    public void loadRecipes() {
        this.clear();
        if (((Boolean)ConfigRecycler.general.recycle_enchanted_book.get()).booleanValue()) {
            this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151134_bR), new ItemStack[0]));
        }
        this.loadUnbalanced();
        this.loadBlacklist();
        this.loadDefaultRecipes();
        this.loadUserDefinedRecipes();
        this.loadGrindList();
    }

    private void clear() {
        this.recipes.clear();
        this.unbalanced.clear();
        this.blacklist.clear();
        this.grindList.clear();
    }

    private void loadUnbalanced() {
        if (!this.unbalancedFile.exists()) {
            this.addToCollection(this.unbalanced, Blocks.field_196650_c);
            this.addToCollection(this.unbalanced, Blocks.field_196654_e);
            this.addToCollection(this.unbalanced, Blocks.field_196656_g);
            this.addToCollection(this.unbalanced, Items.field_151121_aF);
            this.addToCollection(this.unbalanced, Items.field_151102_aT);
            this.addToCollection(this.unbalanced, Items.field_151061_bv);
            this.addToCollection(this.unbalanced, Items.field_151065_br);
            this.addToCollection(this.unbalanced, Items.field_151064_bs);
            this.addToCollection(this.unbalanced, Items.field_151059_bz);
            this.addToCollection(this.unbalanced, Blocks.field_196817_hS);
            this.addToCollection(this.unbalanced, Blocks.field_196814_hQ);
            this.addToCollection(this.unbalanced, Blocks.field_196650_c);
            this.saveAsJson(this.unbalancedFile, this.unbalanced.stream().map(this::itemStackToString).collect(Collectors.toList()));
        } else {
            RecyclingManager.loadAsJson(this.unbalancedFile, String.class).forEach(c -> {
                ItemStack currentStack = this.stringToItemStack((String)c);
                if (!currentStack.func_190926_b()) {
                    this.unbalanced.add(currentStack);
                }
            });
        }
    }

    private void loadBlacklist() {
        if (!this.blacklistFile.exists()) {
            this.addToCollection(this.blacklist, ModBlocks.recycler);
            this.saveAsJson(this.blacklistFile, this.blacklist.stream().map(this::itemStackToString).collect(Collectors.toList()));
        } else {
            RecyclingManager.loadAsJson(this.blacklistFile, String.class).forEach(c -> {
                ItemStack currentStack = this.stringToItemStack((String)c);
                if (!currentStack.func_190926_b()) {
                    this.blacklist.add(currentStack);
                }
            });
        }
    }

    private void saveBlacklist() {
        ArrayList blacklistItems = new ArrayList();
        this.recipes.stream().filter(p -> !p.isAllowed()).forEach(c -> blacklistItems.add(this.itemStackToString(c.getItemRecipe())));
        this.saveAsJson(this.blacklistFile, blacklistItems);
    }

    private RecyclingRecipe getRecipe(int index) {
        return this.recipes.get(index);
    }

    private void addRecipe(RecyclingRecipe recipe) {
        this.recipes.add(recipe);
    }

    public boolean removeRecipe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        int index = this.getRecipeIndex(stack);
        if (index < 0) {
            return false;
        }
        if (this.recipes.get(index).isUserDefined()) {
            this.recipes.remove(index);
            this.saveUserDefinedRecipes();
        } else {
            this.recipes.get(index).setAllowed(false);
            this.saveBlacklist();
        }
        return true;
    }

    public List<RecyclingRecipe> getPage(int pageNum, String searchText) {
        return this.recipes.stream().filter(p -> !(!p.isAllowed() || (Boolean)ConfigRecycler.general.unbalanced_recipes.get() == false && p.isUnbalanced() || !searchText.isEmpty() && !p.getItemRecipe().func_200301_q().func_150261_e().contains(searchText))).skip(pageNum * 4).limit(4L).collect(Collectors.toList());
    }

    public int getPageCount(String searchText) {
        return (int)this.recipes.stream().filter(p -> !(!p.isAllowed() || (Boolean)ConfigRecycler.general.unbalanced_recipes.get() == false && p.isUnbalanced() || !searchText.isEmpty() && !p.getItemRecipe().func_200301_q().func_150261_e().contains(searchText))).count();
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack) {
        int recipeId = this.hasRecipe(stack);
        return recipeId >= 0 ? this.recipes.get(recipeId) : null;
    }

    public int hasRecipe(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_151134_bR && ItemEnchantedBook.func_92110_g((ItemStack)stack).size() < 2) {
            return -1;
        }
        int recipeId = this.getRecipeIndex(stack);
        if (recipeId < 0) {
            return -1;
        }
        RecyclingRecipe recipe = this.recipes.get(recipeId);
        if (!((Boolean)ConfigRecycler.general.unbalanced_recipes.get()).booleanValue() && recipe.isUnbalanced()) {
            return -1;
        }
        if (((Boolean)ConfigRecycler.general.only_user_recipes.get()).booleanValue() && !recipe.isUserDefined()) {
            return -1;
        }
        if (!recipe.isAllowed()) {
            return -1;
        }
        return recipeId;
    }

    private int getRecipeIndex(ItemStack stack) {
        return stack.func_190926_b() ? -1 : IntStream.range(0, this.recipes.size()).filter(slotId -> Helper.areItemEqual(stack, this.recipes.get(slotId).getItemRecipe())).findFirst().orElse(-1);
    }

    public List<ItemStack> getResultStack(ItemStack stack, int nb_input) {
        return this.getResultStack(stack, nb_input, false);
    }

    public List<ItemStack> getResultStack(ItemStack stack, int nb_input, boolean half) {
        ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>();
        int num_recipe = this.hasRecipe(stack);
        if (num_recipe < 0) {
            return itemsList;
        }
        RecyclingRecipe currentRecipe = this.recipes.get(num_recipe);
        boolean isDamagedStack = stack.func_77958_k() > 0 && stack.func_77952_i() > 0;
        for (int i = 0; i < currentRecipe.getCount(); ++i) {
            int leftStackCount;
            int currentSize;
            ItemStack currentStack;
            ItemStack grind;
            ItemStack itemStack = grind = isDamagedStack || half ? this.getGrind(currentRecipe.getStack(i)) : ItemStack.field_190927_a;
            if (grind.func_190926_b()) {
                currentStack = currentRecipe.getStack(i).func_77946_l();
                currentSize = currentStack.func_190916_E();
            } else {
                currentStack = grind;
                currentSize = currentRecipe.getStack(i).func_190916_E() * grind.func_190916_E();
            }
            float modifiedSize = currentSize;
            if (isDamagedStack) {
                modifiedSize = modifiedSize * (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            }
            if (half) {
                modifiedSize /= 2.0f;
            }
            currentStack.func_190920_e(currentStack.func_77976_d());
            for (leftStackCount = currentSize = (int)((Boolean)ConfigRecycler.general.recycle_round_down.get() != false ? Math.floor(modifiedSize) : (double)Math.round(modifiedSize)) * nb_input; leftStackCount >= currentStack.func_77976_d(); leftStackCount -= currentStack.func_77976_d()) {
                itemsList.add(currentStack.func_77946_l());
            }
            if (leftStackCount <= 0) continue;
            currentStack.func_190920_e(leftStackCount);
            itemsList.add(currentStack.func_77946_l());
        }
        if (((Boolean)ConfigRecycler.general.recycle_magic_item.get()).booleanValue()) {
            itemsList.addAll(this.getEnchantedBooks(stack));
        }
        return itemsList;
    }

    private List<ItemStack> getEnchantedBooks(ItemStack stack) {
        Map<Enchantment, Integer> enchants = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p -> p.getKey() != null && p.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<ItemStack> books = new ArrayList<ItemStack>();
        if (!enchants.isEmpty()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                if (enchants.size() < 2) {
                    return books;
                }
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                    ItemEnchantedBook.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                    books.add(currentBook);
                }
            } else {
                ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    ItemEnchantedBook.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                }
                books.add(currentBook);
            }
        }
        return books;
    }

    private void loadGrindList() {
        if (!this.grindFile.exists()) {
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)ModItems.diamond_shard, 9)));
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_191525_da, 9)));
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151074_bl, 9)));
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)new ItemStack((IItemProvider)Items.field_151116_aA), (Object)new ItemStack((IItemProvider)Items.field_179555_bs, 4)));
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y, 4)));
            this.saveAsJson(this.grindFile, this.grindList.stream().map(p -> new ImmutablePair((Object)this.itemStackToString((ItemStack)p.getLeft()), (Object)this.itemStackToString((ItemStack)p.getRight()))).collect(Collectors.toList()));
        } else {
            Type token = new TypeToken<List<ImmutablePair<String, String>>>(){}.getType();
            List<?> jsonStringList = this.loadAsJson(this.grindFile, token);
            for (ImmutablePair pair : jsonStringList) {
                ItemStack input = this.stringToItemStack((String)pair.getLeft());
                ItemStack output = this.stringToItemStack((String)pair.getRight());
                if (input.func_190926_b() || output.func_190926_b()) continue;
                this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)input, (Object)output));
            }
        }
    }

    private ItemStack getGrind(ItemStack stack) {
        for (ImmutablePair<ItemStack, ItemStack> grind : this.grindList) {
            if (!Helper.areItemEqual((ItemStack)grind.getLeft(), stack)) continue;
            return ((ItemStack)grind.getRight()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private boolean saveUserDefinedRecipes() {
        ArrayList<JsonRecyclingRecipe> jRecipes = new ArrayList<JsonRecyclingRecipe>();
        for (RecyclingRecipe recipe : this.recipes) {
            if (!recipe.isUserDefined()) continue;
            jRecipes.add(this.convertRecipeToJson(recipe));
        }
        return this.saveAsJson(this.userDefinedFile, jRecipes);
    }

    public boolean saveAsJson(File file, List<?> list) {
        if (file.exists() && !file.delete()) {
            ModRecycler.LOGGER.warn("can't delete file " + file.getName());
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(new GsonBuilder().setPrettyPrinting().create().toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private List<?> loadAsJson(File file, Type token) {
        List list = new ArrayList();
        try {
            list = (List)new Gson().fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static <T> List<T> loadAsJson(File file, Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JsonArray arrayDatas = new JsonParser().parse((Reader)new BufferedReader(new FileReader(file))).getAsJsonArray();
            for (JsonElement elem : arrayDatas) {
                list.add(new Gson().fromJson(elem, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private void loadUserDefinedRecipes() {
        List<Object> jsonRecipesList;
        if (!this.userDefinedFile.exists()) {
            jsonRecipesList = new ArrayList<JsonRecyclingRecipe>();
            jsonRecipesList.add(new JsonRecyclingRecipe("corail_recycler:recycler:1", new String[]{"minecraft:acacia_planks:4", "minecraft:iron_ingot:4", "minecraft:chest:1"}));
            this.saveAsJson(this.userDefinedFile, jsonRecipesList);
        } else {
            jsonRecipesList = RecyclingManager.loadAsJson(this.userDefinedFile, JsonRecyclingRecipe.class);
        }
        for (JsonRecyclingRecipe jsonRecyclingRecipe : jsonRecipesList) {
            RecyclingRecipe recipe = this.convertJsonRecipe(jsonRecyclingRecipe);
            if (recipe != null && recipe.getCount() > 0) {
                int foundRecipe = this.getRecipeIndex(recipe.getItemRecipe());
                recipe.setUserDefined(true);
                recipe.setAllowed(this.blacklist.stream().noneMatch(p -> Helper.areItemEqual(p, recipe.getItemRecipe())));
                if (foundRecipe == -1) {
                    this.recipes.add(recipe);
                    continue;
                }
                this.recipes.set(foundRecipe, recipe);
                continue;
            }
            ModRecycler.LOGGER.warn("Error while reading json recipe : " + jsonRecyclingRecipe.inputItem);
        }
    }

    @Nullable
    private RecyclingRecipe convertJsonRecipe(JsonRecyclingRecipe jRecipe) {
        ItemStack inputItem = this.stringToItemStack(jRecipe.inputItem);
        if (inputItem.func_190926_b()) {
            return null;
        }
        RecyclingRecipe recipe = new RecyclingRecipe(inputItem);
        Arrays.stream(jRecipe.outputItems).map(this::stringToItemStack).filter(outputItem -> !outputItem.func_190926_b()).forEach(recipe::addStack);
        recipe.setUnbalanced(this.unbalanced.stream().anyMatch(p -> Helper.areItemEqual(p, recipe.getItemRecipe())));
        return recipe;
    }

    @Nullable
    public JsonRecyclingRecipe convertRecipeToJson(RecyclingRecipe recipe) {
        String inputItem = this.itemStackToString(recipe.getItemRecipe());
        if (inputItem.isEmpty()) {
            return null;
        }
        String[] outputItems = new String[recipe.getCount().intValue()];
        for (int i = 0; i < recipe.getCount(); ++i) {
            String outputItem;
            outputItems[i] = outputItem = this.itemStackToString(recipe.getStack(i));
        }
        return new JsonRecyclingRecipe(inputItem, outputItems);
    }

    private String itemStackToString(ItemStack stack) {
        assert (stack.func_77973_b().getRegistryName() != null);
        return stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_190916_E();
    }

    private ItemStack stringToItemStack(String stringStack) {
        Item item;
        String[] parts = stringStack.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new ItemStack((IItemProvider)item, parts.length == 3 ? Integer.valueOf(parts[2]) : 1);
        }
        return ItemStack.field_190927_a;
    }

    private void addToCollection(Collection<ItemStack> list, @Nullable Block block) {
        if (block != null) {
            this.addToCollection(list, block.func_199767_j());
        }
    }

    private void addToCollection(Collection<ItemStack> list, @Nullable Item item) {
        if (item != null && item.getRegistryName() != null) {
            list.add(new ItemStack((IItemProvider)item));
        }
    }

    public <T extends IRecipe> RecyclingRecipe convertCraftingRecipe(T iRecipe) {
        RecyclingRecipe recipe = new RecyclingRecipe(iRecipe.func_77571_b(), Helper.mergeStackInList(iRecipe.func_192400_c().stream().filter(p -> p.func_193365_a().length > 0 && !p.func_193365_a()[0].func_190926_b()).map(m -> m.func_193365_a()[0]).collect(Collectors.toList())));
        recipe.setUnbalanced(false);
        recipe.setUserDefined(true);
        recipe.setAllowed(true);
        return recipe;
    }

    private void loadDefaultRecipes() {
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196650_c), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196654_e), new ItemStack((IItemProvider)Items.field_151128_bU)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196654_e), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Items.field_151128_bU)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196656_g, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_196654_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151121_aF), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196608_cF)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151102_aT), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196608_cF)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151061_bv), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151079_bi), new ItemStack((IItemProvider)Items.field_151065_br)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151065_br, 2), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151072_bj)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151064_bs), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151123_aH)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151059_bz, 3), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151016_H), new ItemStack((IItemProvider)Items.field_151044_h)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_185771_cX, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_185767_cT)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196806_hJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150377_bs)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_185769_cV), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_185771_cX, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_185767_cT), new ItemStack[]{new ItemStack((IItemProvider)Items.field_185162_cT)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_185768_cU), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_185767_cT)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_185764_cQ, 4), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151072_bj), new ItemStack((IItemProvider)Items.field_185162_cT)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185159_cQ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j), new ItemStack((IItemProvider)Blocks.field_196662_n, 6)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150348_b), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196652_d), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196650_c)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196655_f), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196654_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196657_h), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196656_g)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196660_k, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150346_d), new ItemStack((IItemProvider)Blocks.field_150351_n)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150435_aG), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151119_aD, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150405_ch), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150435_aG)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196722_fD), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196791_fw), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196782_fr), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196719_fA), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196793_fx), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196783_fs), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196777_fo), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196795_fy), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196780_fq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196721_fC), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196778_fp), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196720_fB), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196785_ft), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196787_fu), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196797_fz), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196789_fv), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150405_ch, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192442_dQ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196722_fD)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196876_iu), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196791_fw)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192430_dE), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196782_fr)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192439_dN), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196719_fA)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192436_dK), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196793_fx)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192431_dF), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196783_fs)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192427_dB), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196777_fo)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192437_dL), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196795_fy)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192429_dD), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196780_fq)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192441_dP), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196721_fC)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192428_dC), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196778_fp)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192440_dO), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196720_fB)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192432_dG), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196785_ft)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192433_dH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196787_fu)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192438_dM), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196797_fz)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_192434_dI), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196789_fv)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150341_Y), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150395_bd)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150359_w), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150410_aZ, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196824_gy, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196816_gr, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196810_gm, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196821_gv, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196818_gs, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196811_gn, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196807_gj, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196819_gt, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196809_gl, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196823_gx, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196808_gk, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196822_gw, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196812_go, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196813_gp, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196820_gu, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196815_gq, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196776_gO, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196824_gy, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196767_gH, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196816_gr, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196760_gC, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196810_gm, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196773_gL, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196821_gv, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196768_gI, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196818_gs, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196761_gD, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196811_gn, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196825_gz, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196807_gj, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196769_gJ, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196819_gt, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196759_gB, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196809_gl, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196775_gN, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196823_gx, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196758_gA, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196808_gk, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196774_gM, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196822_gw, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196763_gE, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196812_go, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196764_gF, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196813_gp, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196771_gK, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196820_gu, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196765_gG, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196815_gq, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150322_A), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180395_cM), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196611_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196583_aj), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150322_A)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196580_bH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150322_A)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196798_hA), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_180395_cM)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196582_bJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_180395_cM)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196696_di), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196698_dj), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196696_di), new ItemStack((IItemProvider)Blocks.field_150395_bd)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196702_dl), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196696_di)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196700_dk), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196696_di)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196584_bK), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151118_aC, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150426_aN), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151114_aO, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180397_cI), new ItemStack[]{new ItemStack((IItemProvider)Items.field_179562_cC, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196779_gQ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_179562_cC, 9)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196781_gR), new ItemStack[]{new ItemStack((IItemProvider)Items.field_179562_cC, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180398_cJ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_179563_cD, 5), new ItemStack((IItemProvider)Items.field_179562_cC, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150371_ca), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151128_bU, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196772_fk), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150371_ca)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196770_fj), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150371_ca)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196662_n, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196617_K)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196664_o, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196618_L)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196666_p, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196619_M)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196668_q, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196620_N)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196670_r, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196621_O)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196672_s, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196623_P)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151118_aC), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151119_aD)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150433_aE), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151126_ay, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150367_z), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 7), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151031_f)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196586_al), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 8), new ItemStack((IItemProvider)Items.field_151137_ax)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150486_ae), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150477_bB), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150343_Z, 8), new ItemStack((IItemProvider)Items.field_151061_bv)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150447_bR), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150486_ae), new ItemStack((IItemProvider)Blocks.field_150479_bC)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150462_ai), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150460_al), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150421_aI), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 8), new ItemStack((IItemProvider)Items.field_151045_i)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150381_bn), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 2), new ItemStack((IItemProvider)Blocks.field_150343_Z, 4), new ItemStack((IItemProvider)Items.field_151122_aG)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150461_bJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150343_Z, 3), new ItemStack((IItemProvider)Items.field_151156_bN), new ItemStack((IItemProvider)Blocks.field_150359_w, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150467_bQ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 31)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196717_eY), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 20)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196718_eZ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 10)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150453_bW), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196622_bq, 3), new ItemStack((IItemProvider)Blocks.field_150359_w, 3), new ItemStack((IItemProvider)Items.field_151128_bU, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150438_bZ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 5), new ItemStack((IItemProvider)Blocks.field_150486_ae)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150409_cd), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 7), new ItemStack((IItemProvider)Items.field_151137_ax)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150448_aq, 16), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150319_E, 6), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 6), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Blocks.field_150456_au)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196552_aC, 6), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 6), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150408_cc, 6), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 6), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150320_F, 1), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Blocks.field_150331_J)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150331_J, 1), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j), new ItemStack((IItemProvider)Blocks.field_150347_e, 4), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196556_aL), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196570_aZ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196602_ba), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196563_aS), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196564_aT), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196560_aP), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196557_aM), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196558_aN), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196567_aW), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196559_aO), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196561_aQ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196568_aX), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196565_aU), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196569_aY), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196566_aV), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196562_aR), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196622_bq, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196624_br, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196627_bs, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196630_bt, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196632_bu, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196635_bv, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150333_U, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196640_bx, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150322_A)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196646_bz, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196578_bE, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_180395_cM)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203200_bP, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_180397_cI)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203201_bQ, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196779_gQ)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203202_bR, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196781_gR)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196576_bD, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196772_fk)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196575_bC, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196653_dH)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196573_bB, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196702_dl)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196571_bA, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196584_bK)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150335_W), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Items.field_151016_H, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150342_X), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 6), new ItemStack((IItemProvider)Items.field_151122_aG, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150478_aa, 4), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150476_ad), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196622_bq, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150485_bF), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196624_br, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150487_bG), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196627_bs, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150481_bH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196630_bt, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150400_ck), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196632_bu, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150401_cl), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196635_bv, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150372_bz), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196640_bx, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180396_cN), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196578_bE, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150370_cb), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196772_fk, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150387_bl), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196653_dH, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196659_cl), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203210_he), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_180397_cI, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203211_hf), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196779_gQ, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203212_hg), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196781_gR, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150389_bf), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196584_bK, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150390_bg), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196702_dl, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150468_ap, 3), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150442_at), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)Blocks.field_150347_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196663_cq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196665_cr), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196667_cs), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196669_ct), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196671_cu), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196673_cv), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150456_au), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150443_bT), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150445_bS), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150429_aA), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196689_eF), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196691_eG), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196693_eH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196695_eI), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196697_eJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196699_eK), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150430_aB), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180407_aO, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180408_aP, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180404_aQ, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180403_aR, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180405_aT, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180406_aS, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 4), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150386_bk), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196653_dH)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180390_bo), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180391_bp), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180392_bq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180386_br), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180387_bt), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180385_bs), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 2), new ItemStack((IItemProvider)Items.field_151055_y, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196628_cT), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196625_cS), new ItemStack((IItemProvider)Blocks.field_150478_aa)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196636_cW, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196638_cX, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196641_cY, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196644_cZ, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196682_da, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196684_db, 1), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180400_cw, 1), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150411_aY), new ItemStack[]{new ItemStack((IItemProvider)Items.field_191525_da, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150379_bu), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151137_ax, 4), new ItemStack((IItemProvider)Blocks.field_150426_aN)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150479_bC, 2), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)Blocks.field_196662_n), new ItemStack((IItemProvider)Items.field_151042_j)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150463_bK), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196723_eg), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150341_Y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196753_fW, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196602_ba, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196724_fH, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196556_aL, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196745_fS, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196567_aW, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196729_fK, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196559_aO, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196727_fJ, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196558_aN, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196741_fQ, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196565_aU, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196749_fU, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196569_aY, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196731_fL, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196560_aP, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196733_fM, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196561_aQ, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196735_fN, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196562_aR, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196751_fV, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196570_aZ, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196737_fO, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196563_aS, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196739_fP, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196564_aT, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196747_fT, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196568_aX, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196725_fI, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196557_aM, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196743_fR, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196566_aV, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151033_d), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j), new ItemStack((IItemProvider)Items.field_151145_ak)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151055_y, 2), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151054_z, 4), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180413_ao), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180414_ap), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180412_aq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180411_ar), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180410_as), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_180409_at), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150454_av), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151159_an), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y, 8), new ItemStack((IItemProvider)Blocks.field_196556_aL)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151155_ap, 3), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151133_ar), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151140_bW), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack((IItemProvider)Blocks.field_150438_bZ)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151142_bV), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack((IItemProvider)Blocks.field_150335_W, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151109_aJ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack((IItemProvider)Blocks.field_150460_al)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151108_aI), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack((IItemProvider)Blocks.field_150486_ae)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151124_az), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185150_aH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196664_o, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185151_aI), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196666_p, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185152_aJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196668_q, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185153_aK), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196670_r, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185154_aL), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196672_s, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151122_aG), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151121_aF, 3), new ItemStack((IItemProvider)Items.field_151116_aA)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151111_aL), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151042_j, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151112_aM), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 2), new ItemStack((IItemProvider)Items.field_151055_y, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151113_aN), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 4), new ItemStack((IItemProvider)Items.field_151137_ax)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196633_cV), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b, 3), new ItemStack((IItemProvider)Blocks.field_150429_aA, 2), new ItemStack((IItemProvider)Items.field_151137_ax)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196762_fd), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150348_b, 3), new ItemStack((IItemProvider)Blocks.field_150429_aA), new ItemStack((IItemProvider)Items.field_151128_bU)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151069_bo), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150382_bo), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 3), new ItemStack((IItemProvider)Items.field_151072_bj)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150383_bp), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151160_bD), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y, 8), new ItemStack((IItemProvider)Items.field_151116_aA)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_150457_bL), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151118_aC, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151146_bM), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151172_bF), new ItemStack((IItemProvider)Items.field_151112_aM)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_179565_cj), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y, 6), new ItemStack((IItemProvider)Blocks.field_150333_U)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151058_ca, 2), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 4), new ItemStack((IItemProvider)Items.field_151123_aH)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196206_ev), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196602_ba, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196191_eg), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196556_aL, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196202_er), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196567_aW, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196194_ej), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196559_aO, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196198_en), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196563_aS, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196199_eo), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196564_aT, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196204_et), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196569_aY, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196196_el), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196561_aQ, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196195_ek), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196560_aP, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196193_ei), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196558_aN, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196200_ep), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196565_aU, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196201_eq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196566_aV, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196197_em), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196562_aR, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196203_es), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196568_aX, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196192_eh), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196557_aM, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196201_eq), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196566_aV, 6), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185158_cP), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150359_w, 7), new ItemStack((IItemProvider)Items.field_151061_bv), new ItemStack((IItemProvider)Items.field_151073_bk)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151148_bJ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151111_aL), new ItemStack((IItemProvider)Items.field_151121_aF, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151097_aZ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151039_o), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151050_s), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151035_b), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151005_D), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151046_w), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151053_p), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151049_t), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151036_c), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151006_E), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151056_x), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 3), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151038_n), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151051_r), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151037_a), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151011_C), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151047_v), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151041_m), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 2), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151052_q), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 2), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151040_l), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 2), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151010_B), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 2), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151048_u), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 2), new ItemStack((IItemProvider)Items.field_151055_y)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151017_I), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196662_n, 2), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151018_J), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 2), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151019_K), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 2), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151013_M), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 2), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151012_L), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 2), new ItemStack((IItemProvider)Items.field_151055_y, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151031_f), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151007_F, 3), new ItemStack((IItemProvider)Items.field_151055_y, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151032_g), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151008_G), new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)Items.field_151145_ak)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_185166_h, 2), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151114_aO, 4), new ItemStack((IItemProvider)Items.field_151032_g)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151021_T), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151116_aA, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151024_Q), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151116_aA, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151027_R), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151116_aA, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151026_S), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151116_aA, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151167_ab), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151028_Y), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151030_Z), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151165_aa), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151151_aj), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151169_ag), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151171_ah), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151149_ai), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151175_af), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151161_ac), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151163_ad), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 8)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_151173_ae), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151045_i, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196653_dH), new ItemStack[]{new ItemStack((IItemProvider)Items.field_196154_dH, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196817_hS), new ItemStack[]{new ItemStack((IItemProvider)Items.field_196154_dH, 2), new ItemStack((IItemProvider)Items.field_151075_bm, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196814_hQ), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151064_bs, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_190976_dk), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150347_e, 6), new ItemStack((IItemProvider)Items.field_151137_ax, 2), new ItemStack((IItemProvider)Items.field_151128_bU)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196884_jh, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196860_iS, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196874_iZ, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196877_ja, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196880_jd, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196866_iV, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196868_iW, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196870_iX, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196882_jf, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196878_jb, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196864_iU, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196881_je, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196872_iY, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196879_jc, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196862_iT, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_196883_jg, 8), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150354_m, 4), new ItemStack((IItemProvider)Blocks.field_150351_n, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196099_bJ), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196602_ba, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196140_bu), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196556_aL, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196091_bB), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196563_aS, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196092_bC), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196564_aT, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196095_bF), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196567_aW, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196146_bx), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196559_aO, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196148_by), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196560_aP, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196150_bz), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196561_aQ, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196097_bH), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196569_aY, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196093_bD), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196565_aU, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196144_bw), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196558_aN, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196096_bG), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196568_aX, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196090_bA), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196562_aR, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196094_bE), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196566_aV, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196142_bv), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196557_aM, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_196098_bI), new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196570_aZ, 3), new ItemStack((IItemProvider)Blocks.field_196662_n, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Items.field_203179_ao), new ItemStack[]{new ItemStack((IItemProvider)Items.field_203183_eM, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_205165_jY), new ItemStack[]{new ItemStack((IItemProvider)Items.field_205157_eZ, 8), new ItemStack((IItemProvider)Items.field_205158_fa)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((IItemProvider)Blocks.field_203216_jz), new ItemStack[]{new ItemStack((IItemProvider)Items.field_203180_bP, 9)}));
    }
}

