/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.util;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TranslationHelper {
    public static void sendMessage(@Nullable EntityPlayerMP sender, LangKey langKey, Object ... params) {
        if (sender != null && !sender.field_70170_p.field_72995_K) {
            sender.func_145747_a(langKey.getTranslation(params));
        }
    }

    public static ITextComponent createTranslation(String message, Object ... params) {
        return new TextComponentTranslation(message, params);
    }

    public static ITextComponent createTranslationWithStyle(StyleType styleType, String message, Object ... params) {
        return TranslationHelper.createTranslation(message, params).func_150255_a(styleType.getStyle());
    }

    public static enum LangKey {
        MESSAGE_ADD_RECIPE_SUCCESS("message.add_recipe_success"),
        MESSAGE_ADD_RECIPE_FAILED("message.add_recipe_failed"),
        MESSAGE_EXPORT_SUCCESS("message.export_success"),
        MESSAGE_EXPORT_FAILED("message.export_failed"),
        MESSAGE_REMOVE_RECIPE_SUCCESS("message.remove_recipe_success"),
        MESSAGE_REMOVE_RECIPE_FAILED("message.remove_recipe_failed"),
        MESSAGE_FOUND_RECIPES("message.found_recipes"),
        MESSAGE_RECYCLING_BOOK("message.recycling_book"),
        MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS("message.not_enough_output_slots"),
        MESSAGE_LOSS("message.loss"),
        MESSAGE_BROKEN_DISK("message.broken_disk"),
        BUTTON_RECYLE("button.recycle"),
        BUTTON_AUTO("button.auto"),
        BUTTON_TAKE_ALL("button.takeAll"),
        BUTTON_DISCOVER_RECIPE("button.discoverRecipe"),
        BUTTON_REMOVE_RECIPE("button.removeRecipe");

        private final String key;

        private LangKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return "corail_recycler." + this.key;
        }

        public ITextComponent getTranslation(Object ... params) {
            return new TextComponentTranslation(this.getKey(), params);
        }
    }

    public static enum StyleType {
        MESSAGE_NORMAL(TextFormatting.WHITE, false, false),
        MESSAGE_SPECIAL(TextFormatting.GOLD, false, false),
        TOOLTIP_DESC(TextFormatting.GRAY, true, false);

        private final Style style;

        private StyleType(TextFormatting color, boolean isItalic, boolean isBold) {
            this.style = new Style().func_150238_a(color).func_150217_b(Boolean.valueOf(isItalic)).func_150227_a(Boolean.valueOf(isBold));
        }

        public Style getStyle() {
            return this.style;
        }

        public String getStyleString() {
            return this.style.toString();
        }
    }
}

