/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler;

import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.recycler.command.CommandRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.config.RecyclerModConfig;
import ovh.corail.recycler.gui.GuiRecycler;
import ovh.corail.recycler.gui.GuiRecyclingBook;
import ovh.corail.recycler.item.ItemDisk;
import ovh.corail.recycler.network.ClientProxy;
import ovh.corail.recycler.network.IProxy;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerProxy;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.registry.ModContainers;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.registry.ModTabs;
import ovh.corail.recycler.registry.ModTriggers;

@Mod(value="corail_recycler")
public class ModRecycler {
    public static final String MOD_ID = "corail_recycler";
    public static final String MOD_NAME = "Corail Recycler";
    public static final Logger LOGGER = LogManager.getLogger((String)"corail_recycler");
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public ModRecycler() {
        Reflection.initialize((Class[])new Class[]{PacketHandler.class, ModTriggers.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        this.registerSharedConfig(context.getActiveContainer());
        context.registerConfig(ModConfig.Type.COMMON, ConfigRecycler.GENERAL_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        PROXY.preInit();
    }

    private void registerSharedConfig(ModContainer modContainer) {
        modContainer.addConfig((ModConfig)new RecyclerModConfig(ConfigRecycler.SHARED_GENERAL_SPEC, modContainer));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        new CommandRecycler((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        RecyclingManager.instance.loadRecipes();
        LOGGER.info(RecyclingManager.instance.getRecipeCount() + " recycling recipes loaded");
    }

    private void clientInit(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModContainers.RECYCLER, GuiRecycler::new);
        ScreenManager.func_216911_a(ModContainers.RECYCLING_BOOK, GuiRecyclingBook::new);
        ((Minecraft)event.getMinecraftSupplier().get()).getItemColors().func_199877_a(ItemDisk::getColor, new IItemProvider[]{ModItems.diamond_disk, ModItems.steel_disk});
    }
}

