/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemInput;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.LangKey;

public class CommandRecycler {
    private final CommandDispatcher<CommandSource> commandDispatcher;

    public CommandRecycler(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    private int processAddRecipe(CommandSource source, SimpleStack ingredient, SimpleStack ... results) {
        ServerPlayerEntity player = source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
        RecyclingRecipe recipe = new RecyclingRecipe(ingredient, results);
        if (Helper.isValidRecipe(recipe) && RecyclingManager.instance.addRecipe(recipe.setUserDefined(true)).saveUserDefinedRecipes()) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private int processDiscoverRecipe(CommandSource source, ItemStack stack) {
        ServerPlayerEntity player;
        ServerPlayerEntity serverPlayerEntity = player = source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
        if (stack.func_190926_b() && player != null) {
            stack = player.func_184614_ca();
        }
        if (!stack.func_190926_b() && RecyclingManager.instance.discoverRecipe(source.func_197023_e(), stack)) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private int processRemoveRecipe(CommandSource source, ItemStack stack) {
        ServerPlayerEntity player;
        ServerPlayerEntity serverPlayerEntity = player = source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
        if (stack.func_190926_b() && player != null) {
            stack = player.func_184614_ca();
        }
        if (!stack.func_190926_b() && RecyclingManager.instance.removeRecipe(stack)) {
            LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_REMOVE_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private int processExportCraftingRecipes(CommandSource source) {
        ServerPlayerEntity player = source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
        RecyclingManager rm = RecyclingManager.instance;
        NonNullList list = source.func_197023_e().func_199532_z().func_215366_a(IRecipeType.field_222149_a).values().stream().filter(recipe -> Helper.isValidRecipe((IRecipe<CraftingInventory>)recipe) && rm.getRecipe(recipe.func_77571_b(), false) == null).map(recipe -> new JsonRecyclingRecipe((ICraftingRecipe)recipe)).collect(Collectors.toCollection(NonNullList::func_191196_a));
        LangKey.MESSAGE_FOUND_RECIPES.sendMessage((PlayerEntity)player, list.size());
        File exportFile = new File(RecyclingManager.instance.CONFIG_DIR, "export_crafting_recipes.json");
        boolean success = rm.saveAsJson(exportFile, list);
        (success ? LangKey.MESSAGE_EXPORT_SUCCESS : LangKey.MESSAGE_EXPORT_FAILED).sendMessage((PlayerEntity)player, new Object[0]);
        return 1;
    }

    private int showUsage(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("recycler <command>"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("discover_recipe : add the recycling recipe of the crafting result of the item hold in main hand"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("remove_recipe : remove the recycling recipe of the item hold in main hand"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("export_crafting_recipes : save the list of all crafting recipes in \"recycling\" format in the config directory"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("add_recipe : add a custom recipe based on the ingredient and results provided in param <item> <count>"), false);
        return 1;
    }

    public void registerCommand() {
        LiteralArgumentBuilder createRecipeBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.ADD_RECIPE.func_176610_l()).executes(this::showUsage);
        createRecipeBuilder.then(this.createItemArgument("ing").then(this.createIntegerArgument("ingc", null).then(this.createItemArgument("r1").then(this.createIntegerArgument("r1c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1")))).then(this.createItemArgument("r2").then(this.createIntegerArgument("r2c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2")))).then(this.createItemArgument("r3").then(this.createIntegerArgument("r3c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3")))).then(this.createItemArgument("r4").then(this.createIntegerArgument("r4c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4")))).then(this.createItemArgument("r5").then(this.createIntegerArgument("r5c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4"), this.createStack((CommandContext<CommandSource>)c, "r5")))).then(this.createItemArgument("r6").then(this.createIntegerArgument("r6c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4"), this.createStack((CommandContext<CommandSource>)c, "r5"), this.createStack((CommandContext<CommandSource>)c, "r6")))).then(this.createItemArgument("r7").then(this.createIntegerArgument("r7c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4"), this.createStack((CommandContext<CommandSource>)c, "r5"), this.createStack((CommandContext<CommandSource>)c, "r6"), this.createStack((CommandContext<CommandSource>)c, "r7")))).then(this.createItemArgument("r8").then(this.createIntegerArgument("r8c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4"), this.createStack((CommandContext<CommandSource>)c, "r5"), this.createStack((CommandContext<CommandSource>)c, "r6"), this.createStack((CommandContext<CommandSource>)c, "r7"), this.createStack((CommandContext<CommandSource>)c, "r8")))).then(this.createItemArgument("r9").then(this.createIntegerArgument("r9c", (Command<CommandSource>)((Command)c -> this.processAddRecipe((CommandSource)c.getSource(), this.createStack((CommandContext<CommandSource>)c, "ing"), this.createStack((CommandContext<CommandSource>)c, "r1"), this.createStack((CommandContext<CommandSource>)c, "r2"), this.createStack((CommandContext<CommandSource>)c, "r3"), this.createStack((CommandContext<CommandSource>)c, "r4"), this.createStack((CommandContext<CommandSource>)c, "r5"), this.createStack((CommandContext<CommandSource>)c, "r6"), this.createStack((CommandContext<CommandSource>)c, "r7"), this.createStack((CommandContext<CommandSource>)c, "r8"), this.createStack((CommandContext<CommandSource>)c, "r9"))))))))))))))))))))))));
        this.commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"recycler").requires(p -> p.func_197034_c(2))).executes(this::showUsage)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.DISCOVER_RECIPE.func_176610_l()).executes(c -> this.processDiscoverRecipe((CommandSource)c.getSource(), ItemStack.field_190927_a))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> this.processDiscoverRecipe((CommandSource)c.getSource(), ItemArgument.func_197316_a((CommandContext)c, (String)"item").func_197320_a(1, false)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.REMOVE_RECIPE.func_176610_l()).executes(c -> this.processRemoveRecipe((CommandSource)c.getSource(), ItemStack.field_190927_a))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> this.processRemoveRecipe((CommandSource)c.getSource(), ItemArgument.func_197316_a((CommandContext)c, (String)"item").func_197320_a(1, false)))))).then(Commands.func_197057_a((String)CommandAction.EXPORT_CRAFTING_RECIPES.func_176610_l()).executes(c -> this.processExportCraftingRecipes((CommandSource)c.getSource())))).then((ArgumentBuilder)createRecipeBuilder));
    }

    private RequiredArgumentBuilder<CommandSource, ItemInput> createItemArgument(String itemName) {
        return (RequiredArgumentBuilder)Commands.func_197056_a((String)itemName, (ArgumentType)ItemArgument.func_197317_a()).executes(this::showUsage);
    }

    private RequiredArgumentBuilder<CommandSource, Integer> createIntegerArgument(String intName, @Nullable Command<CommandSource> action) {
        return (RequiredArgumentBuilder)Commands.func_197056_a((String)intName, (ArgumentType)IntegerArgumentType.integer()).executes(action == null ? this::showUsage : action);
    }

    private SimpleStack createStack(CommandContext<CommandSource> context, String name) {
        return new SimpleStack(ItemArgument.func_197316_a(context, (String)name).func_197319_a(), IntegerArgumentType.getInteger(context, (String)(name + "c")));
    }

    private static enum CommandAction implements IStringSerializable
    {
        DISCOVER_RECIPE,
        REMOVE_RECIPE,
        EXPORT_CRAFTING_RECIPES,
        ADD_RECIPE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

