/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.network.UpdateConfigMessage;

public class ConfigRecycler {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final ForgeConfigSpec SHARED_GENERAL_SPEC;
    public static final General general;
    public static final SharedGeneral shared_general;

    private static String getTranslation(String name) {
        return "corail_recycler.config." + name;
    }

    public static UpdateConfigMessage getUpdatePacket() {
        return new UpdateConfigMessage((Boolean)ConfigRecycler.shared_general.unbalanced_recipes.get(), (Boolean)ConfigRecycler.shared_general.allow_automation.get());
    }

    public static void updateConfig(UpdateConfigMessage packet) {
        ConfigRecycler.shared_general.unbalanced_recipes.set((Object)packet.unbalanced_recipes);
        ConfigRecycler.shared_general.allow_automation.set((Object)packet.allow_automation);
    }

    static {
        Pair confGeneral = new ForgeConfigSpec.Builder().configure(General::new);
        general = (General)confGeneral.getLeft();
        GENERAL_SPEC = (ForgeConfigSpec)confGeneral.getRight();
        Pair confSharedGeneral = new ForgeConfigSpec.Builder().configure(SharedGeneral::new);
        shared_general = (SharedGeneral)confSharedGeneral.getLeft();
        SHARED_GENERAL_SPEC = (ForgeConfigSpec)confSharedGeneral.getRight();
    }

    @Mod.EventBusSubscriber(modid="corail_recycler", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEvent {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onReloadConfig(ModConfig.ConfigReloading event) {
            if (event.getConfig().getModId().equals("corail_recycler") && event.getConfig().getType() == ModConfig.Type.SERVER) {
                ModRecycler.PROXY.markConfigDirty();
            }
        }
    }

    public static class SharedGeneral {
        public final ForgeConfigSpec.ConfigValue<Boolean> unbalanced_recipes;
        public final ForgeConfigSpec.ConfigValue<Boolean> allow_automation;

        SharedGeneral(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.unbalanced_recipes = builder.comment("unbalanced_recipes [false/true|default:false]").translation(ConfigRecycler.getTranslation("unbalanced_recipes")).define("unbalanced_recipes", false);
            this.allow_automation = builder.comment("allow_automation [false/true|default:true]").translation(ConfigRecycler.getTranslation("allow_automation")).define("allow_automation", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> only_user_recipes;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycle_magic_item;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycle_enchanted_book;
        public final ForgeConfigSpec.ConfigValue<Integer> chance_loss;
        public final ForgeConfigSpec.ConfigValue<Boolean> allow_sound;
        public final ForgeConfigSpec.ConfigValue<Integer> time_to_recycle;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycle_round_down;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.only_user_recipes = builder.comment("only_user_recipes [false/true|default:false]").translation(ConfigRecycler.getTranslation("only_user_recipes")).define("only_user_recipes", false);
            this.recycle_magic_item = builder.comment("recycle_magic_item [false/true|default:true]").translation(ConfigRecycler.getTranslation("recycle_magic_item")).define("recycle_magic_item", true);
            this.recycle_enchanted_book = builder.comment("recycle_enchanted_book [false/true|default:true]").translation(ConfigRecycler.getTranslation("recycle_enchanted_book")).define("recycle_enchanted_book", true);
            this.chance_loss = builder.comment("chance_loss [0..100|default:0]").translation(ConfigRecycler.getTranslation("chance_loss")).defineInRange("chance_loss", 0, 0, 100);
            this.allow_sound = builder.comment("allow_sound [false/true|default:true]").translation(ConfigRecycler.getTranslation("allow_sound")).define("allow_sound", true);
            this.time_to_recycle = builder.comment("time_to_recycle [5..10000|default:100]").translation(ConfigRecycler.getTranslation("time_to_recycle")).defineInRange("time_to_recycle", 100, 5, 10000);
            this.recycle_round_down = builder.comment("recycle_round_down [false/true|default:false]").translation(ConfigRecycler.getTranslation("recycle_round_down")).define("recycle_round_down", false);
            builder.pop();
        }
    }
}

