/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.gui.ButtonRecycler;
import ovh.corail.recycler.gui.ContainerRecycler;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclerMessage;
import ovh.corail.recycler.network.ServerRecyclingBookMessage;
import ovh.corail.recycler.util.LangKey;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecycler
extends ContainerScreen<ContainerRecycler> {
    private static final ResourceLocation TEXTURE_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private final ResourceLocation TEXTURE_BAR = new ResourceLocation("textures/gui/bars.png");
    private boolean isInit = true;

    public GuiRecycler(ContainerRecycler container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 232;
        this.field_147000_g = 203;
    }

    public void init() {
        super.init();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.addButton((Widget)new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 120, 53, 14, I18n.func_135052_a((String)LangKey.BUTTON_RECYLE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.RECYCLE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.addButton((Widget)new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 139, 53, 14, I18n.func_135052_a((String)LangKey.BUTTON_AUTO.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.SWITCH_AUTO, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.addButton((Widget)new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 157, 53, 14, I18n.func_135052_a((String)LangKey.BUTTON_TAKE_ALL.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.TAKE_ALL, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.addButton((Widget)new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 175, 53, 14, I18n.func_135052_a((String)LangKey.BUTTON_DISCOVER_RECIPE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.DISCOVER_RECIPE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.addButton((Widget)new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 175, 53, 14, I18n.func_135052_a((String)LangKey.BUTTON_REMOVE_RECIPE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.REMOVE_RECIPE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.addButton((Widget)new ImageButton(this.field_147003_i + 148, this.field_147009_r + 64, 20, 18, 178, 0, 19, field_147001_a, pressable -> PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.RECYCLING_BOOK, new Object[0]))));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_RECYCLER);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Slot slot : ((ContainerRecycler)this.func_212873_a_()).field_75151_b) {
            this.blit(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 110, 238, 18, 18);
            if (!(slot instanceof SlotRecycler)) continue;
            SlotRecycler currentSlot = (SlotRecycler)slot;
            if (this.isInit) {
                currentSlot.timeInUse = 0;
                continue;
            }
            if (currentSlot.timeInUse <= 0) continue;
            this.blit(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 110, 203, 18, 18);
            --currentSlot.timeInUse;
        }
        this.isInit = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int entityX = 86;
        int entityY = 50;
        InventoryScreen.func_147046_a((int)entityX, (int)entityY, (int)20, (float)(2 * entityX - mouseX), (float)(entityY - mouseY), (LivingEntity)this.getMinecraft().field_71439_g);
        this.getMinecraft().field_71446_o.func_110577_a(TEXTURE_RECYCLER);
        this.blit(115, 81, 79, 210, 22, 15);
        if (((ContainerRecycler)this.field_147002_h).isWorking() && ((ContainerRecycler)this.field_147002_h).getInputMax() > 0) {
            this.blit(115, 81, 79, 225, ((ContainerRecycler)this.field_147002_h).getProgress() * 22 / 100, 15);
        }
        int currentPower = ((ContainerRecycler)this.field_147002_h).getEnergy();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.TEXTURE_BAR);
        GuiRecycler.blit((int)70, (int)112, (float)0.0f, (float)20.0f, (int)136, (int)3, (int)136, (int)256);
        GuiRecycler.blit((int)70, (int)112, (float)0.0f, (float)25.0f, (int)((int)(96.56 * (double)currentPower) / ((ContainerRecycler)this.field_147002_h).getRecycler().getMaxEnergy()), (int)2, (int)136, (int)256);
        GuiRecycler.blit((int)70, (int)112, (float)0.0f, (float)81.0f, (int)136, (int)3, (int)136, (int)256);
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)0.6, (double)0.6, (double)0.6);
        Slot diskSlot = (Slot)((ContainerRecycler)this.field_147002_h).field_75151_b.get(1);
        ItemStack diskStack = diskSlot.func_75211_c();
        int useLeft = diskStack.func_190926_b() ? 0 : (diskStack.func_77958_k() - diskStack.func_77952_i()) / 10;
        this.font.func_211126_b(useLeft + "", (float)((int)((double)(diskSlot.field_75223_e + 20) / 0.6)), (float)((int)((double)(diskSlot.field_75221_f + 4) / 0.6)), useLeft > 0 ? 65280 : 0xFF0000);
        Slot recycledSlot = (Slot)((ContainerRecycler)this.field_147002_h).field_75151_b.get(0);
        this.font.func_211126_b(((ContainerRecycler)this.field_147002_h).getInputMax() + "", (float)((int)((double)(recycledSlot.field_75223_e + 20) / 0.6)), (float)((int)((double)(recycledSlot.field_75221_f + 4) / 0.6)), ((ContainerRecycler)this.field_147002_h).getInputMax() > 0 ? 65280 : 0xFF0000);
        this.font.func_211126_b(String.format("%5s", currentPower) + " / " + ((ContainerRecycler)this.field_147002_h).getRecycler().getMaxEnergy(), 200.0f, 173.0f, currentPower >= 10 ? 65280 : 0xFF0000);
        GlStateManager.popMatrix();
    }

    public void onClose() {
        super.onClose();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.updateButtons();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void updateButtons() {
        boolean isEmptySlot = ((ContainerRecycler)this.field_147002_h).getRecycler().getInventoryWorking().getStackInSlot(0).func_190926_b();
        boolean hasPermission = this.getMinecraft().field_71439_g.func_195070_dx();
        boolean hasRecipe = IntStream.range(0, ((ContainerRecycler)this.field_147002_h).getRecycler().getInventoryVisual().getSlots()).anyMatch(slot -> !((ContainerRecycler)this.field_147002_h).getRecycler().getInventoryVisual().getStackInSlot(slot).func_190926_b());
        ((Widget)this.buttons.get((int)0)).active = hasRecipe && ((ContainerRecycler)this.field_147002_h).getInputMax() > 0 && !((ContainerRecycler)this.field_147002_h).isWorking();
        ((Widget)this.buttons.get((int)1)).active = (Boolean)ConfigRecycler.shared_general.allow_automation.get() != false && hasRecipe && !((ContainerRecycler)this.field_147002_h).getRecycler().getInventoryWorking().getStackInSlot(1).func_190926_b();
        ((Widget)this.buttons.get((int)2)).active = !((ContainerRecycler)this.field_147002_h).getRecycler().isOutputEmpty();
        ((Widget)this.buttons.get((int)3)).visible = hasPermission && !hasRecipe && !isEmptySlot;
        ((Widget)this.buttons.get((int)3)).active = ((Widget)this.buttons.get((int)3)).visible;
        ((Widget)this.buttons.get((int)4)).visible = hasPermission && hasRecipe && !isEmptySlot;
        ((Widget)this.buttons.get((int)4)).active = ((Widget)this.buttons.get((int)4)).visible;
    }
}

