/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.gui.ButtonRecyclingBook;
import ovh.corail.recycler.gui.ContainerRecyclingBook;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclingBookMessage;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.LangKey;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecyclingBook
extends ContainerScreen<ContainerRecyclingBook> {
    private TextFieldWidget searchBox;
    private String lastText = "";
    private static final ResourceLocation TEXTURE_VANILLA_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private static final ResourceLocation TEXTURE_RECYCLING_BOOK = new ResourceLocation("corail_recycler:textures/gui/book.png");
    private final int textColor = 13938487;
    private Map<Integer, Rectangle2d> recipeFlags = new HashMap<Integer, Rectangle2d>();

    public GuiRecyclingBook(ContainerRecyclingBook container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 250;
        this.field_147000_g = 150;
    }

    public void init() {
        super.init();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.addButton((Widget)new ButtonRecyclingBook(false, this.field_147003_i + 20, this.field_147009_r + 135, pressable -> {
            if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() > 0) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((ContainerRecyclingBook)this.field_147002_h).getPageNum() - 1));
            }
        }));
        this.addButton((Widget)new ButtonRecyclingBook(true, this.field_147003_i + 208, this.field_147009_r + 135, pressable -> {
            if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() < ((ContainerRecyclingBook)this.field_147002_h).getPageMax()) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((ContainerRecyclingBook)this.field_147002_h).getPageNum() + 1));
            }
        }));
        this.recipeFlags.clear();
        ((ContainerRecyclingBook)this.field_147002_h).field_75151_b.stream().filter(slot -> Helper.atInterval(slot.getSlotIndex(), 10, false)).forEach(slot -> {
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            int slotId = slot.getSlotIndex() / 10;
            this.recipeFlags.put(slotId * 3, new Rectangle2d(startPosX, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 1, new Rectangle2d(startPosX + 5, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 2, new Rectangle2d(startPosX + 10, startPosY + 16, 5, 5));
        });
        this.searchBox = new TextFieldWidget(this.font, this.width / 2 - 32, this.field_147009_r + 139, 64, 12, "search");
        this.addButton((Widget)this.searchBox);
        this.configureSearchBox();
    }

    private void configureSearchBox() {
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146195_b(true);
        this.searchBox.func_146203_f(20);
        this.searchBox.func_146180_a("");
        this.searchBox.func_146205_d(false);
    }

    private void updateButton(int buttonNum, boolean state) {
        Widget button = (Widget)this.buttons.get(buttonNum);
        button.active = button.visible = state;
    }

    private void updateButtons() {
        if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() <= 0) {
            ((ContainerRecyclingBook)this.field_147002_h).setPageNum(0);
            this.updateButton(0, false);
            this.updateButton(1, ((ContainerRecyclingBook)this.field_147002_h).getPageMax() > 0);
        } else if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() >= ((ContainerRecyclingBook)this.field_147002_h).getPageMax()) {
            ((ContainerRecyclingBook)this.field_147002_h).setPageNum(((ContainerRecyclingBook)this.field_147002_h).getPageMax());
            this.updateButton(0, true);
            this.updateButton(1, false);
        } else {
            this.updateButton(0, true);
            this.updateButton(1, true);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
        }
        if (keyCode == 259) {
            String text = this.searchBox.func_146179_b();
            if (text.length() < 2) {
                this.searchBox.func_146180_a("");
            } else {
                this.searchBox.func_146180_a(text.substring(0, text.length() - 1));
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchBox.charTyped(Character.toLowerCase(p_charTyped_1_), p_charTyped_2_)) {
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public void tick() {
        String currentText;
        super.tick();
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && Helper.atInterval(world.func_82737_E(), 10) && !this.lastText.equals(currentText = this.searchBox.func_146179_b())) {
            this.lastText = currentText;
            PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.SEARCH_TEXT, this.searchBox.func_146179_b().toLowerCase()));
        }
    }

    public void onClose() {
        super.onClose();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.updateButtons();
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_RECYCLING_BOOK);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_VANILLA_RECYCLER);
        for (Slot slot : ((ContainerRecyclingBook)this.field_147002_h).field_75151_b) {
            Rectangle2d pos;
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            this.blit(startPosX, startPosY, 112, 222, 16, 16);
            if (!Helper.atInterval(slot.getSlotIndex(), 10, false)) continue;
            int recipeId = slot.getSlotIndex() / 10;
            if (((ContainerRecyclingBook)this.field_147002_h).isUserDefinedRecipe(recipeId)) {
                pos = this.recipeFlags.get(recipeId * 3);
                GuiRecyclingBook.fill((int)pos.func_199318_a(), (int)pos.func_199319_b(), (int)(pos.func_199318_a() + pos.func_199316_c()), (int)(pos.func_199319_b() + pos.func_199317_d()), (int)-16776961);
            }
            if (((ContainerRecyclingBook)this.field_147002_h).isBlacklistRecipe(recipeId)) {
                pos = this.recipeFlags.get(recipeId * 3 + 1);
                GuiRecyclingBook.fill((int)pos.func_199318_a(), (int)pos.func_199319_b(), (int)(pos.func_199318_a() + pos.func_199316_c()), (int)(pos.func_199319_b() + pos.func_199317_d()), (int)-16777216);
            }
            if (((ContainerRecyclingBook)this.field_147002_h).isUnbalancedRecipe(recipeId)) {
                pos = this.recipeFlags.get(recipeId * 3 + 2);
                GuiRecyclingBook.fill((int)pos.func_199318_a(), (int)pos.func_199319_b(), (int)(pos.func_199318_a() + pos.func_199316_c()), (int)(pos.func_199319_b() + pos.func_199317_d()), (int)-11530192);
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        ((ContainerRecyclingBook)this.field_147002_h).field_75151_b.stream().filter(slot -> {
            int recipeId;
            return Helper.atInterval(slot.getSlotIndex(), 10, false) && (((ContainerRecyclingBook)this.field_147002_h).isBlacklistRecipe(recipeId = slot.getSlotIndex() / 10) || (Boolean)ConfigRecycler.shared_general.unbalanced_recipes.get() == false && ((ContainerRecyclingBook)this.field_147002_h).isUnbalancedRecipe(recipeId));
        }).forEach(slot -> {
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            this.drawCross(startPosX + 21, startPosY - 16, startPosX + 69, startPosY + 32, -65536);
        });
        this.recipeFlags.entrySet().stream().filter(p -> ((Rectangle2d)p.getValue()).func_199315_b(mouseX, mouseY)).findFirst().ifPresent(entry -> {
            boolean valid;
            int recipeId = (Integer)entry.getKey() / 3;
            int type = (Integer)entry.getKey() % 3;
            boolean bl = type == 0 ? ((ContainerRecyclingBook)this.field_147002_h).isUserDefinedRecipe(recipeId) : (valid = type == 1 ? ((ContainerRecyclingBook)this.field_147002_h).isBlacklistRecipe(recipeId) : ((ContainerRecyclingBook)this.field_147002_h).isUnbalancedRecipe(recipeId));
            if (valid) {
                this.renderTooltip(type == 0 ? "user defined" : (type == 1 ? "blacklist" : "unbalanced"), mouseX, mouseY);
            }
        });
        super.func_191948_b(mouseX, mouseY);
    }

    private void drawCross(float x1, float y1, float x2, float y2, int color) {
        float[] color4F = Helper.getRGBColor4F(color);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GlStateManager.lineWidth((float)2.5f);
        bufferbuilder.func_181662_b((double)x1, (double)y1, (double)this.blitOffset).func_181666_a(color4F[0], color4F[1], color4F[2], color4F[3]).func_181675_d();
        bufferbuilder.func_181662_b((double)x2, (double)y2, (double)this.blitOffset).func_181666_a(color4F[0], color4F[1], color4F[2], color4F[3]).func_181675_d();
        bufferbuilder.func_181662_b((double)x2, (double)y1, (double)this.blitOffset).func_181666_a(color4F[0], color4F[1], color4F[2], color4F[3]).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y2, (double)this.blitOffset).func_181666_a(color4F[0], color4F[1], color4F[2], color4F[3]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
        ((ContainerRecyclingBook)this.field_147002_h).field_75151_b.stream().filter(p -> Helper.atInterval(p.getSlotIndex(), 10, false) && !p.func_75211_c().func_190926_b()).forEach(c -> this.drawString(this.font, c.func_75211_c().func_200301_q().func_150261_e(), (c.field_75223_e - 2) * 2, (c.field_75221_f - 22) * 2, this.textColor));
        this.font.func_175063_a(((ContainerRecyclingBook)this.field_147002_h).getPageNum() + 1 + "/" + (((ContainerRecyclingBook)this.field_147002_h).getPageMax() + 1), 428.0f, 240.0f, this.textColor);
        GlStateManager.popMatrix();
        String title = TextFormatting.BOLD + I18n.func_135052_a((String)LangKey.MESSAGE_RECYCLING_BOOK.getKey(), (Object[])new Object[0]);
        this.font.func_175063_a(title, (float)(this.field_146999_f - this.font.func_78256_a(title)) / 2.0f, -10.0f, this.textColor);
    }
}

